DELIMITER $$
DROP PROCEDURE IF EXISTS V20241009113253__Create_EmailAccountStmtScholarshipEvent $$
CREATE PROCEDURE V20241009113253__Create_EmailAccountStmtScholarshipEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM `dtprovider` WHERE `dataProviderName`='ACCOUNT_STATEMENT_SPONSOR')) THEN 
-- Ahdoc msg for sponsor contact

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'ACCOUNT_STATEMENT_SPONSOR', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ACCOUNT_STATEMENT_SPONSOR');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'ACCOUNT_STATEMENT_SPONSOR');

INSERT INTO `adhoc_msg_recipient_type` (`msgRecipientTypeId`, `distrListProviderId`) VALUES (@msgRecipientId+1, @dtproviderId);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ACCOUNT_STATEMENT_SPONSOR');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
'SELECT 
    T1.id AS ID,
    T2.`contactName` AS FIRST_NAME,
	T2.`contactName` AS SPONSOR_CONTACT_PERSON_NAME,
	(Case 
    	when 
      		T1.`emailType` = "PRIMARY"
   		then 
   			T3.`primaryeEmailId`
    	when 
    		T1.`emailType` = "ALTERNATE"
     	then 
        	T3.`alternateEmailId`
     	else "" 
      end) AS EMAIL_ID,
	DATE_FORMAT(NOW(), "%d-%m-%Y") AS CURRENT_DATE_TODAY,
	T4.`scholarshipCode` AS SCHOLARSHIP_ID,
	T4.`scholarshipName` AS SCHOLARSHIP_NAME,
	(Case 
    	when 
      		T4.`scholarshipCategory` = "NOMINATION"
   		then 
   			"Nomination"
     	else T4.`scholarshipCategory`
      end) AS SCHOLARSHIP_CATEGORY,
	T5.`accountingYear` AS ACCOUNTING_YEAR,
	T8.`externalSysRefOne` AS STUDENT_EXTERNAL_REFERENCE_NUMBER_1,
	T6.`code` AS STUDENT_NUMBER,
	T6.`printName` AS STUDENT_PRINT_NAME
FROM   
    `send_account_stmt_to_sponsor` T1 
        LEFT JOIN
    `sponsor_contacts` T2 ON T2.`id` = T1.`sponsorContactId`
		LEFT JOIN
    `address` T3 ON T3.`id` = T2.`addressId`
		LEFT JOIN
    `scholarship` T4 ON T4.`id` = T1.`scholarshipId`
		LEFT JOIN
    `accounting_year` T5 ON T5.`id` = T1.`accountingYearId`
		LEFT JOIN
    `users` T6 ON T6.`id` = T1.`studentId`
		LEFT JOIN
    `students` T7 ON T7.`userId` = T6.`id`
		LEFT JOIN
    `persons` T8 ON T8.`id` = T7.`personId`
WHERE
    T1.id IN (namedParams)','{
  "id": 1,
  "searchResultViewColumns": [
    {
      "id": 1,
      "value": "contactName",
      "resultKey": "SPONSOR_CONTACT_PERSON_NAME",
      "displayCode": "",
      "displayOrder": 0
    },
    {
      "id": 2,
      "value": "Current Date",
      "resultKey": "CURRENT_DATE_TODAY",
      "displayCode": "",
      "displayOrder": 1
    },
    {
      "id": 3,
      "value": "scholarshipCode",
      "resultKey": "SCHOLARSHIP_ID",
      "displayCode": "",
      "displayOrder": 2
    },
    {
      "id": 4,
      "value": "scholarshipName",
      "resultKey": "SCHOLARSHIP_NAME",
      "displayCode": "",
      "displayOrder": 3
    },
    {
      "id": 5,
      "value": "scholarshipCategory",
      "resultKey": "SCHOLARSHIP_CATEGORY",
      "displayCode": "",
      "displayOrder": 4
    },
    {
      "id": 6,
      "value": "accountingYear",
      "resultKey": "ACCOUNTING_YEAR",
      "displayCode": "",
      "displayOrder": 5
    },
    {
      "id": 7,
      "value": "externalSysRefOne",
      "resultKey": "STUDENT_EXTERNAL_REFERENCE_NUMBER_1",
      "displayCode": "",
      "displayOrder": 6
    },
    {
      "id": 8,
      "value": "code",
      "resultKey": "STUDENT_NUMBER",
      "displayCode": "",
      "displayOrder": 7
    },
    {
      "id": 9,
      "value": "printName",
      "resultKey": "STUDENT_PRINT_NAME",
      "displayCode": "",
      "displayOrder": 8
    }
  ]
}');

-- set predefine msg template for statement of account
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @msgTemplateConfigId=(SELECT MAX(id) FROM `msg_template_config`);
SET @msgrecipienttypeId=(SELECT id FROM msg_recipient_type WHERE `code`='ACCOUNT_STATEMENT_SPONSOR');
INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`,`approvalRequired`,`approverId`,`whetherStaticMsg`,`status`,`availableForAdhocMsg`,`academyLocationId`,`authorName`,`authorId`,`templatelanguageValue`) 
VALUES (@msgTemplateConfigId+1,'Email Account Statement - Scholarship',64,NULL,@msgrecipienttypeId,4,NULL,NULL,'Email Account Statement - Scholarship',NULL,0,NULL,0,'APPROVED',1,1,'System Admin',1,'English');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','','');

END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='ACCOUNT_STATEMENT_SPONSOR')) THEN
INSERT INTO `picklist_translation` (`key`, en) VALUES ('ACCOUNT_STATEMENT_SPONSOR', 'Account Statement Sponsor');
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='ACCOUNT_STATEMENT_SPONSOR')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'ACCOUNT_STATEMENT_SPONSOR', 'Account Statement Sponsor', 'Account Statement Sponsor', 'Rekeningstaatborg', 'Sao kê tài khoản',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='SPONSOR_CONTACT_PERSON_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'SPONSOR_CONTACT_PERSON_NAME', 'Sponsor Contact Person Name', 'Sponsor Contact Person Name', 'Borg Kontakpersoon Naam', 'Tên người liên hệ của nhà tài trợ',now(),1);
END IF;

END $$

CALL V20241009113253__Create_EmailAccountStmtScholarshipEvent () $$ 
DROP PROCEDURE IF EXISTS V20241009113253__Create_EmailAccountStmtScholarshipEvent $$ 
DELIMITER ;