DELIMITER $$
DROP PROCEDURE IF EXISTS V20241018123732__Update_PnCProgramWiseStdAttendance $$
CREATE PROCEDURE V20241018123732__Update_PnCProgramWiseStdAttendance()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS (select dataProviderName from dtprovider where dataProviderName='DAILY_STUDENT_MARKED_ABSENT_FOR_THE_DAY_RCPNT') THEN 

SET @dayAbsent=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILY_STUDENT_MARKED_ABSENT_FOR_THE_DAY_RCPNT');

UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT     
    T2.id AS ID,
	T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.emailId AS EMAIL_ID,
	T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
	T6.displayName AS ACADEMY_NAME,    
    DATE_FORMAT(T1.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
	'ATTENDANCE_PROGRAM' AS MSG_CATEGORY
FROM
    student_program_attendance T1
        LEFT JOIN
    student_program_attendance_details T2 ON T2.attendanceId = T1.id
        LEFT JOIN
    admission T3 ON T3.id = T2.admissionId
		LEFT JOIN
    students T4 ON T4.userId = T3.studentId
		LEFT JOIN
    persons T5 ON T5.id = T4.personId
		LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
		LEFT JOIN
    fire_base_persons_info f ON f.userId = T4.userId
    
WHERE
	T2.attendanceStatus = 'ABSENT'
	AND T2.id IN (namedParams) group by T2.id"
WHERE
    `dataProviderId`=@dayAbsent;

END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20241018123732__Update_PnCProgramWiseStdAttendance () $$
DROP PROCEDURE IF EXISTS V20241018123732__Update_PnCProgramWiseStdAttendance $$
DELIMITER ;