DELIMITER $$
DROP PROCEDURE IF EXISTS getDTEFAdmissionDetails  $$
CREATE PROCEDURE getDTEFAdmissionDetails(IN applicantinfo TINYTEXT)
BEGIN
SET @query = CONCAT("select distinct aperson.nationalID as nationalId, al.academyName as institution,  prog.programCode as institution_program_code,  aperson.lastName as surname,  concat(COALESCE(aperson.firstName,''), ' ', COALESCE(aperson.middleName,'')) as firstname,  prog.programName as  program_name,  prog_othdet.programMinDurationTime as program_duration,  bat.startDate as start_date,  bat.tillDate as completion_date, ci.displayOrder as entry_level, bat.estimatedFees as cost,  dtef.id as dtefMapId,dtef.applicationProgramId dtefAppProgId,dtef.response as dtefResponse, dtef.responseStatus as dtefResponseStatus,dtef.responseDate as dtefResponseDate, dtef.lastUpdate as dtefLastUpdate,dtef.lastUpdatedBy as dtefLastUpdatedBy, dtef.applicantPersonId as dtefApplicantPersonId   from application ap  join application_program ap_prog  on ap.id=ap_prog.applicationId  join academy_location al  on ap_prog.academyLocationId=al.id  join programs prog  on ap_prog.programId=prog.id left outer  join program_group prog_group  on prog.programGroupId=prog_group.id   left outer join program_other_details prog_othdet on prog.id=prog_othdet.programId   left outer join prog_batch_seat_config seat  on ap_prog.progBatchSeatConfigId=seat.id   left outer join batches bat  on seat.programBatchId=bat.id   left outer join intake_year intake  on bat.intakeYearId=intake.id   left outer join applicant_person aperson  on ap.applicantPersonId=aperson.id   left outer join applicant_person_cd apcd  on aperson.id=apcd.applicantPersonId  left outer join  categories_info ci on ci.id = apcd.cf11  left outer join dtef_app_prog_mapping dtef on dtef.applicationProgramId = ap_prog.id  and dtef.applicantPersonId = aperson.id and (dtef.responseStatus != 'SUCCESS' or dtef.responseStatus is null)  where (aperson.id,ap_prog.id) in (",applicantinfo,") "); 

PREPARE stmt FROM @query;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

END$$

DELIMITER ;