DELIMITER $$
DROP PROCEDURE IF EXISTS V20241029120405__Create_StdPersonalDetailApplyHold $$
CREATE PROCEDURE V20241029120405__Create_StdPersonalDetailApplyHold()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_personal_detail_apply_hold')) THEN 
CREATE TABLE `student_personal_detail_apply_hold`(
`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
`holdCatId` BIGINT(20) NOT NULL,
`subHoldCatId` BIGINT(20) DEFAULT NULL,
`firstName`  VARCHAR(255) DEFAULT NULL,
`middleName`  VARCHAR(255) DEFAULT NULL,
`lastName`  VARCHAR(255) DEFAULT NULL,
`nationalID`  VARCHAR(100) DEFAULT NULL,
`studentId` BIGINT(20) DEFAULT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `student_personal_detail_apply_hold_holdCatId_FK` FOREIGN KEY (`holdCatId`) REFERENCES `manage_hold_category` (`id`),
CONSTRAINT `student_personal_detail_apply_hold_sub_holdCatId_FK` FOREIGN KEY (`subHoldCatId`) REFERENCES `manage_sub_hold_category`(`id`),
CONSTRAINT `student_personal_detail_apply_hold_studentId_FK` FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`),
CONSTRAINT `student_personal_detail_apply_hold_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) ;
END IF;

END $$
CALL V20241029120405__Create_StdPersonalDetailApplyHold () $$ 
DROP PROCEDURE IF EXISTS V20241029120405__Create_StdPersonalDetailApplyHold $$ 
DELIMITER ;