DELIMITER $$
DROP PROCEDURE IF EXISTS V20241104140025__Insert_EM_NORMANDIE_STUDENT_ID_CARD $$
CREATE PROCEDURE V20241104140025__Insert_EM_NORMANDIE_STUDENT_ID_CARD()
BEGIN

IF NOT EXISTS ((SELECT * FROM report_template WHERE templateCode = 'EM_NORMANDIE_STUDENT_ID_CARD')) THEN 
 INSERT INTO report_template (reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo) 
    VALUES ('7', 'EM_NORMANDIE_STUDENT_ID_CARD', 'EM Normandie Student Id card', 'EM_NORMANDIE_STUDENT_ID_CARD.png', 'CommonReport_EM_NORMANDIE_STUDENT_ID_CARD.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'EM_NORMANDIE_STUDENT_ID_CARD.jasper', 'AcademiaLogo.png');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='EM_NORMANDIE_STUDENT_ID_CARD'))) THEN
	set @stuId = (select id from report_template where templateCode ='EM_NORMANDIE_STUDENT_ID_CARD');
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@stuId, 'STUDENT_TRANS', 'Student', '1', NOW()),
	(@stuId, 'IDENTITY_CARD_TRANS', 'Identity Card', '1', NOW()),
    (@stuId, 'NAME_TRANS', 'Name', '1', NOW()),
	(@stuId, 'DATE_OF_BIRTH_TRANS', 'D.O.B', '1', NOW()),
	(@stuId, 'ID_TRANS', 'ID', '1', NOW()),
	(@stuId, 'CAMPUS_TRANS', 'Campus', '1', NOW()),
	(@stuId, 'PROGRAM_TRANS', 'Program', '1', NOW()),
	(@stuId, 'STUDENT_IDENTITY_CARD_INTAKE_TRANS', 'Student Identity Card', '1', NOW()),
	(@stuId, 'SUMMARY_TRANS', 'This card is valid for the duration of your course, providing you continue to be active with the University. You must carry it all times on University premises, as you may be asked to produce it for identiﬁcation purpose. You must present this card when using the Library and when sitting examinations. 
    You are entitled to use the facilities of the University in accordance with its policies and rules. This card remains the property of the University.', '1', NOW());
  END IF;

END $$
CALL V20241104140025__Insert_EM_NORMANDIE_STUDENT_ID_CARD() $$
DROP PROCEDURE IF EXISTS V20241104140025__Insert_EM_NORMANDIE_STUDENT_ID_CARD $$
DELIMITER ;