DELIMITER $$
DROP PROCEDURE IF EXISTS fatchStudentToBePushInXero $$
CREATE PROCEDURE fatchStudentToBePushInXero(jobLastRunTimestamp timestamp)
BEGIN
SELECT
    func_inc_var_session_rec() AS id,
    user.id as userId,
    user.code as userCode,
    user.status as status,
    user.printName as userName,
    user.firstName as firstName,
    user.lastName as lastName,
    user.shortName as shortName,
    stuPer.emailId as email,
    stuPer.mobileNumber as mobileNumber,
    stuPer.mobileCountryCode as mobileCountryCode,
    1 as locationId,
    userMapping.xeroContactId as xeroContactId,
    'STUDENT'   as role
FROM
    users AS user
		JOIN
    students AS stu ON stu.userId = user.id
		left JOIN
	xero_user_mapping as userMapping ON userMapping.academiaUserId=user.id
		JOIN 
	admission as ad on (ad.studentId=user.id and ad.activeStatus=true)
        JOIN 
    persons AS stuPer ON stuPer.id = stu.personId
		JOIN 
    user_academy_locations AS ual ON ual.userId = user.id
        JOIN 
    user_acad_loc_roles AS ualr ON ualr.userAcadLocationId = ual.id
        JOIN 
    roles AS role ON role.id = ualr.roleId
    where userMapping.id is null and role.roleName ="STUDENT" 
    group by user.id
    UNION ALL SELECT 
	func_inc_var_session_rec() AS id,
    user.id as userId,
    user.code as userCode,
    user.status as status,
    user.printName as userName,
    user.firstName as firstName,
    user.lastName as lastName,
    user.shortName as shortName,
    stuPer.emailId as email,
    stuPer.mobileNumber as mobileNumber,
    stuPer.mobileCountryCode as mobileCountryCode,
    1 as locationId,
    userMapping.xeroContactId as xeroContactId,
    'STUDENT'   as role
   FROM
   users AS user
		JOIN
    students AS stu ON stu.userId = user.id
		JOIN
	xero_user_mapping as userMapping ON userMapping.academiaUserId=user.id
		JOIN 
	admission as ad on (ad.studentId=user.id and ad.activeStatus=true)
        JOIN 
    persons AS stuPer ON stuPer.id = stu.personId
		JOIN 
    user_academy_locations AS ual ON ual.userId = user.id
        JOIN 
    user_acad_loc_roles AS ualr ON ualr.userAcadLocationId = ual.id
        JOIN 
    roles AS role ON role.id = ualr.roleId
    where role.roleName ="STUDENT" and user.lastUpdate > jobLastRunTimestamp 
    group by user.id;
END $$ 
DELIMITER ;