DELIMITER $$
DROP PROCEDURE IF EXISTS fatchExamResultPublishDate $$
CREATE PROCEDURE fatchExamResultPublishDate(studentId BIGINT , courseVariantIds text)
BEGIN
SELECT
    func_inc_var_session_rec() AS id,
    epr.resultPublishDate as resultPublishDate,
    null as moderationPoints,
    epr.evaluationPlanId as evaluationId,
    st.userId as studentId,
    cv.id as courseVariantId,
    "plan" as level
    from evaluation_plan_rank as epr
    join admission as ad on ad.id = epr.admissionId
    join students as st on st.userId=ad.studentId
    join course_variants as cv on cv.id=epr.courseVariantId
    where st.userId = studentId AND FIND_IN_SET(cv.id, courseVariantIds)
    
    union all
    
    SELECT
    func_inc_var_session_rec() AS id,
    epl1.resultPublishDate as resultPublishDate,
    epl1.moderationPoints as moderationPoints,
    epl1.evaluationPlanLevelOneId as evaluationId,
    st.userId as studentId,
    cv.id as courseVariantId,
    "levelOne" as level
    from evaluation_plan_level_one_rank as epl1
    join admission as ad on ad.id = epl1.admissionId
    join students as st on st.userId=ad.studentId
    join course_variants as cv on cv.id=epl1.courseVariantId	
    where st.userId = studentId AND FIND_IN_SET(cv.id, courseVariantIds)
    
	union all
    
    SELECT
    func_inc_var_session_rec() AS id,
    epl2.resultPublishDate as resultPublishDate,
    epl2.moderationPoints as moderationPoints,
    epl2.evaluationPlanLevelTwoId as evaluationId,
    st.userId as studentId,
    cv.id as courseVariantId,
    "levelTwo" as level
    from evaluation_plan_level_two_rank as epl2
    join admission as ad on ad.id = epl2.admissionId
    join students as st on st.userId=ad.studentId
    join course_variants as cv on cv.id=epl2.courseVariantId
    where st.userId = studentId AND FIND_IN_SET(cv.id, courseVariantIds)
    
    union all
    
    SELECT
    func_inc_var_session_rec() AS id,
    epl3.resultPublishDate as resultPublishDate,
    epl3.moderationPoints as moderationPoints,
	epl3.evaluationSequenceId as evaluationId,
    st.userId as studentId,
    cv.id as courseVariantId,
    "levelThree" as level
    from evaluation_sequence_rank as epl3
    join admission as ad on ad.id = epl3.admissionId
    join students as st on st.userId=ad.studentId
    join course_variants as cv on cv.id=epl3.courseVariantId
    where st.userId = studentId AND FIND_IN_SET(cv.id, courseVariantIds)
    
	union all
    
    SELECT
    func_inc_var_session_rec() AS id,
    er.publishDate as resultPublishDate,
    null as moderationPoints,
	er.evaluationDetailSequenceId as evaluationId,
    st.userId as studentId,
    cv.id as courseVariantId,
    "eventLevel" as level
    from examination_result as er
    join admission as ad on ad.id = er.admissionId
    join students as st on st.userId=ad.studentId
    join course_variants as cv on cv.id=er.courseVariantId
    where st.userId = studentId AND FIND_IN_SET(cv.id, courseVariantIds);
   
END $$ 
DELIMITER ;