DELIMITER $$
DROP PROCEDURE IF EXISTS V20241203110837__Create_addHocParticipantLimeSurvey $$
CREATE PROCEDURE V20241203110837__Create_addHocParticipantLimeSurvey()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='academia_lime_survey_adhoc_participant')) THEN 
CREATE TABLE academia_lime_survey_adhoc_participant (
	id BIGINT(20) NOT NULL AUTO_INCREMENT,
    academiaLimeSurveyId BIGINT,
    firstName VARCHAR(50),
    lastName VARCHAR(50),
	code VARCHAR(50),
    email VARCHAR(255),
    accessCode VARCHAR(255),
    studentId BIGINT,
	employeeId BIGINT,
    applicantPersonId BIGINT,
    emailSent BOOLEAN DEFAULT FALSE,
	surveyId BIGINT,
	lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	lastUpdatedBy BIGINT(20) DEFAULT NULL,
	PRIMARY KEY (`id`),
	CONSTRAINT `FK_academia_lime_survey_adhoc_participant_academiaLimeSurveyId` FOREIGN KEY (`academiaLimeSurveyId`) REFERENCES `academia_lime_survey` (`id`),
	CONSTRAINT `FK_academia_lime_survey_adhoc_participant_studentId` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`),
	CONSTRAINT `FK_academia_lime_survey_adhoc_participant_applicantPersonId` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`)	,
	CONSTRAINT `FK_academia_lime_survey_adhoc_participant_employeeId` FOREIGN KEY (`employeeId`) REFERENCES `staffs` (`userId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20241203110837__Create_addHocParticipantLimeSurvey () $$ 
DROP PROCEDURE IF EXISTS V20241203110837__Create_addHocParticipantLimeSurvey $$ 
DELIMITER ;