DELIMITER $$
DROP PROCEDURE IF EXISTS V20241213154623__Insert_UITranslationsAdHocSurvey $$
CREATE PROCEDURE V20241213154623__Insert_UITranslationsAdHocSurvey()
BEGIN

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE `keyName` = 'INVALID_JSON_FORMAT' AND `objectName` = 'TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `vietLanguage`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'INVALID_JSON_FORMAT', 'Invalid format: Input must be a JSON object.', 'Invalid format: Input must be a JSON object.', 'Định dạng không hợp lệ: Đầu vào phải là đối tượng JSON.', "Ongeldige formaat: Invoer moet 'n JSON-voorwerp wees.", NOW(), 1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE `keyName` = 'ATLEAST_ONE_SHOULD_BE_NON_EMPTY_MSG' AND `objectName` = 'TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `vietLanguage`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'ATLEAST_ONE_SHOULD_BE_NON_EMPTY_MSG', 'At least one of studentCodes, employeeCodes, or applicantCodes must be non-empty.', 'At least one of studentCodes, employeeCodes, or applicantCodes must be non-empty.', 'Ít nhất một trong các mã sinh viên, mã nhân viên hoặc mã ứng viên không được để trống.', 'Ten minste een van studentkodes, werknemerkodes of aansoekerkodes moet nie leeg wees nie.', NOW(), 1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE `keyName` = 'SURVEY_QUESTIONS' AND `objectName` = 'TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `vietLanguage`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'SURVEY_QUESTIONS', 'Survey Questions', 'Survey Questions', 'Câu hỏi khảo sát', 'Opname Vrae', NOW(), 1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE `keyName` = 'EMAIL_SENT' AND `objectName` = 'TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `vietLanguage`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'EMAIL_SENT', 'Email Sent Status', 'Email Sent Status', 'Trạng thái đã gửi email', 'E-pos gestuur status', NOW(), 1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE `keyName` = 'PARTICIPANT_ID' AND `objectName` = 'TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `vietLanguage`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'PARTICIPANT_ID', 'Participant ID', 'Participant ID', 'ID người tham gia', 'Deelnemer ID', NOW(), 1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE `keyName` = 'PARTICIPANT_FIRST_NAME' AND `objectName` = 'TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `vietLanguage`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'PARTICIPANT_FIRST_NAME', 'Participant First Name', 'Participant First Name', 'Participant First Name', 'Deelnemer Voornaam', NOW(), 1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE `keyName` = 'PARTICIPANT_LAST_NAME' AND `objectName` = 'TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `vietLanguage`, `afriLanguage`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'PARTICIPANT_LAST_NAME', 'Participant Last Name', 'Participant Last Name', 'Họ của người tham gia', 'Deelnemer Van', NOW(), 1);
END IF; 


END $$
CALL V20241213154623__Insert_UITranslationsAdHocSurvey() $$
DROP PROCEDURE IF EXISTS V20241213154623__Insert_UITranslationsAdHocSurvey $$
DELIMITER ;