DELIMITER $$
DROP PROCEDURE IF EXISTS V20241218163228__Update_PushNotificationForParent $$
CREATE PROCEDURE V20241218163228__Update_PushNotificationForParent()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_PARENTS_RECIPIENT')) THEN 
SET @dtproviderRCPNT=(select id from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_PARENTS_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
     T12.id AS ID,
          T13.firstName AS PARENT_FIRST_NAME,
           T13.lastName AS PARENT_LAST_NAME,
           T13.firstName AS FIRST_NAME,
           T14.salutationName AS PARENT_SALUTATION,
          T3.printName AS STUDENT_PRINT_NAME,
             T5.evaluationGroupCodePrintName AS ASSESSMENT_GROUP_PRINT_NAME,
              T8.programName AS PROGRAM_NAME,
                T10.batchName AS BATCH_NAME,
                   T11.programPeriodName AS PERIOD_NAME,
                         T6.status AS PERIOD_LEVEL_RESULT_STATUS,
                              T7.academyName AS ACADEMY_NAME,
          T7.locationName AS LOCATION_NAME,
          T13.mobileNumber AS MOBILE_NO,
          T13.emailId AS EMAIL_ID,
          'EXAM_MARKSHEET' AS MSG_CATEGORY,
          (SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info
        WHERE
            fire_base_persons_info.userId = T2.userId) AS DEVICE_ID
      FROM
      marksheet_job_details T12 
       left join 
          admission T1 on T12.admissionId=T1.id
                left join
               students as T2 on T2.userId=T1.studentId
               left join 
               persons as T3 on T3.id=T2.personId
               left join
               person_relationships as T15 on (T15.personId=T3.id and T15.relationship='FATHER' and T15.whetherDeleted=false)
               left join 
               persons as T13 on T13.id=T15.relatedPersonId
               left join
               salutations as T14 on T14.id=T13.salutationId
                  left join
               examination_result as T4 on T4.admissionId=T1.id
            left join
               evaluation_group as T5 on T5.id=T4.evaluationGroupId
            left join 
               evaluation_period_rank T6 on T6.admissionId=T1.id
               left join 
               academy_location T7 on T7.id=T1.academyLocationId
               left join 
               programs T8 on T8.id=T1.programId
               left join 
               prog_batch_seat_config T9 on T9.id=T1.programBatchSeatConfigId
                left join 
               prog_batch_period_config T11 on T11.id=T1.programBatchPeriodConfigId
               left join
               batches T10 on T10.id=T9.programBatchId
      WHERE
          T12.id IN (namedParams) limit 1"
WHERE  dataProviderId =@dtproviderRCPNT;
END IF; 

IF EXISTS (SELECT id FROM msg_template_config WHERE `code`='Email Marksheet For Parents Template') THEN 
SET @addUserId=(SELECT id FROM msg_template_config WHERE `code`='Email Marksheet For Parents Template');
IF NOT EXISTS (SELECT * FROM msg_template WHERE msgTemplateConfigId=@addUserId and subjectLine='Email Marksheet For Parents' and msgDeliveryModeId=6) THEN 
INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) VALUES (@addUserId, '6', 'Email Marksheet For Parents','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Dear&nbsp;$recipientData[&quot;PARENT_SALUTATION&quot;]&nbsp;$recipientData[&quot;PARENT_FIRST_NAME&quot;]&nbsp;$recipientData[&quot;PARENT_LAST_NAME&quot;]</span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Congratulations! You Have cleared the Exam&nbsp;$recipientData[&quot;ASSESSMENT_GROUP_PRINT_NAME&quot;]&nbsp;</span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">A detailed marksheet for&nbsp;$recipientData[&quot;PROGRAM_NAME&quot;]&nbsp;$recipientData[&quot;BATCH_NAME&quot;]&nbsp;$recipientData[&quot;PERIOD_NAME&quot;] is attached below. </span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Thanks</span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">$recipientData[&quot;STUDENT_PRINT_NAME&quot;]</span></p>

<p>$recipientData[&quot;PERIOD_LEVEL_RESULT_STATUS&quot;]</p>

<p>$recipientData[&quot;ACADEMY_NAME&quot;]</p>

<p>$recipientData[&quot;LOCATION_NAME&quot;]</p>
</body>
</html>
');
END IF; 
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20241218163228__Update_PushNotificationForParent () $$
DROP PROCEDURE IF EXISTS V20241218163228__Update_PushNotificationForParent $$
DELIMITER ;