CREATE OR REPLACE VIEW `analytics_event_report_view` AS
SELECT DISTINCT
rb.eventDate AS `Event Date`,
rb.id AS `Event_primary_Id`,
rb.eventDesc AS `Event Description`,
rb.whetherCompleteDay AS `Event whether Complete Day`,
rb.whetherMandatory AS `Event whether Mandatory`,
rb.sessionDateSlot AS `Session Date slot`,
rb.whetherRecurring AS `Event Whether Recurring`,
rb.tillDate AS `Event Till Date`,
rb.timeFrom AS `Event Time From`,
rb.timeTo AS `Event Time To`,
rb.`status` AS `Event Active Status`,
rb.eventName AS `Event Name`,
rb.resourceCategoryCode AS `Resource Category Code`,
rb.purpose AS `event Purpose`,
rb.purposeDescription AS `Event Purpose Description`,
rb.noOfParticipants AS `No. of  Participants`,
rb.bookingRemark AS `Event Booking Remark`,
rb.approverRemark AS `Event Approver Remark`,
rb.venue AS `Event Venue`,
rb.conductedBy AS `Event Conducted By`,
rb.whetherDeleted AS `Event Whether Deleted`,
c.committeeCode AS `Event Committee Code`,
c.committeeName AS `Committee Name`,
rb.eventBudget AS `Event Budget`,
CONCAT(
    IFNULL(`per`.`firstName`, ''),
    ' ',
    IFNULL(`per`.`middleName`, ''),
    ' ',
    IFNULL(`per`.`lastName`, '')
  ) AS `fullName`,
  b.batchName AS `Batch Name`,
  p.programName AS `Program Name`,
  p.programCode AS `Program Code`,
  rbau.isRegistered AS `Is Registerd`,
  al.displayName AS `Academy Location`,
  s.salutationName,
  al.academyCode AS `academyCode`,
  al.locationCode AS `locationCode`,
  `u`.`whetherActive` AS `Alumni Active Status`,

  per.signupCode AS `SignUpCode`,
  u.alumniCode AS `Alumni Code`,
 
  (
    DATE_FORMAT(
      FROM_DAYS(
        (
          TO_DAYS(
            curdate()
          ) - TO_DAYS(`per`.`birthDate`)
        )
      ),
      '%Y'
    ) + 0
  ) AS `age`,
  per.gender AS `Gender`,
  bu.printName AS `Booked By`,
  YEAR(rb.eventDate) AS `Event Year`
 FROM resource_booking_alumni_users rbau
JOIN resource_bookings rb ON rbau.resourceBookingId=rb.id AND rb.whetherDeleted=0
JOIN booking_purposes bp ON bp.id=rb.bookingPurposeId
left JOIN committee c ON  c.id=rb.committeeId
LEFT JOIN alumni_users u ON u.id=rbau.alumniUserId
 JOIN alumni_persons per ON per.alumniUserId = u.id
 JOIN academy_location al ON al.id=per.academyLocationId
 JOIN batches b ON b.id=per.batchId
LEFT JOIN programs p ON p.id=b.programId
LEFT JOIN salutations s ON s.id=per.salutationId
LEFT JOIN users bu ON bu.id=rb.bookedBy
WHERE per.`status`='APPROVED';