DELIMITER $$
DROP PROCEDURE IF EXISTS V20241227152827__Create_CreateServiceLecturerCostDtls $$
CREATE PROCEDURE V20241227152827__Create_CreateServiceLecturerCostDtls()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='service_lecturer_cost_dtls')) THEN

CREATE TABLE `service_lecturer_cost_dtls` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`serviceId` BIGINT(20) NOT NULL,
	`coordinatorId` BIGINT(20) NOT NULL,
	`serviceStaffId` BIGINT(20) NOT NULL,
	`fromDate` TIMESTAMP NOT NULL,
  	`tillDate` TIMESTAMP NOT NULL,
	`currencyId` BIGINT(20) NOT NULL,
    	`cost` DOUBLE NOT NULL,
    	`comments` LONGTEXT NOT NULL,
    	`isMapped` BOOLEAN DEFAULT 1,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  	INDEX `fk_service_lecturer_cost_dtls_service_Id_idx` (`serviceId` ASC),
  	INDEX `fk_service_lecturer_cost_dtls_coordinator_Id_idx` (`coordinatorId` ASC),
	INDEX `fk_service_lecturer_cost_dtls_serviceStaff_Id_idx` (`serviceStaffId` ASC),
        INDEX `fk_service_lecturer_cost_dtls_currency_Id_idx` (`currencyId` ASC),
  	INDEX `fk_service_lecturer_cost_dtls_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_service_lecturer_cost_dtls_service_id`
    FOREIGN KEY (`serviceId`)
    REFERENCES `service` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_service_lecturer_cost_dtls_coordinator_id`
    FOREIGN KEY (`coordinatorId`)
    REFERENCES `staffs` (`userId`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
    CONSTRAINT `fk_service_lecturer_cost_dtls_serviceStaff_id`
    FOREIGN KEY (`serviceStaffId`)
    REFERENCES `service_staff` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
    CONSTRAINT `fk_service_lecturer_cost_dtls_currency_id`
    FOREIGN KEY (`currencyId`)
    REFERENCES `currency` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_service_lecturer_cost_dtls_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF;

END $$
CALL V20241227152827__Create_CreateServiceLecturerCostDtls () $$ 
DROP PROCEDURE IF EXISTS V20241227152827__Create_CreateServiceLecturerCostDtls $$ 
DELIMITER ;