DELIMITER $$
DROP PROCEDURE IF EXISTS V20250102120220__Update_StudentJourneyCoreERPGrid $$
CREATE PROCEDURE V20250102120220__Update_StudentJourneyCoreERPGrid()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from data_grid where gridName='Academia.view.personinfo.common.personalinfo.StudentJourneyCoreERPGrid' and portalId=1)) THEN 
update `data_grid` set
`jsonObject` = '[{"id":null,"columnName":"ACADEMIC_TERM","dataIndex":"academicTermCode","columnVisibility":"SHOW","sequence":1,"mandatory":false,"defaultSortBy":null,"orderBy":""},
{"id":null,"columnName":"PERIOD_STATUS","dataIndex":"periodStatus","columnVisibility":"SHOW","sequence":2,"mandatory":false,"defaultSortBy":null,"orderBy":""},
{"id":null,"columnName":"ACADEMY_LOCATION","dataIndex":"academicLocationName","columnVisibility":"SHOW","sequence":3,"mandatory":false,"defaultSortBy":null,"orderBy":""},
{"id":null,"columnName":"CAMPUS","dataIndex":"campusName","columnVisibility":"SHOW","sequence":4,"mandatory":false,"defaultSortBy":null,"orderBy":""},
{"id":null,"columnName":"PROGRAM_NAME","dataIndex":"programName","columnVisibility":"SHOW","sequence":5,"mandatory":false,"defaultSortBy":null,"orderBy":""},
{"id":null,"columnName":"BATCH","dataIndex":"batchName","columnVisibility":"SHOW","sequence":6,"mandatory":false,"defaultSortBy":null,"orderBy":""},
{"id":null,"columnName":"PERIOD_NAME","dataIndex":"periodName","columnVisibility":"SHOW","sequence":7,"mandatory":false,"defaultSortBy":null,"orderBy":""},
{"id":null,"columnName":"SEAT_TYPE","dataIndex":"seatType","columnVisibility":"HIDE","sequence":8,"mandatory":false,"defaultSortBy":null,"orderBy":""},
{"id":null,"columnName":"ENROLLMENT_STATUS","dataIndex":"resultStatus","columnVisibility":"SHOW","sequence":9,"mandatory":false,"defaultSortBy":null,"orderBy":""},
{"id":null,"columnName":"PROGRESSION_STATUS","dataIndex":"progressionStatus","columnVisibility":"SHOW","sequence":10,"mandatory":false,"defaultSortBy":null,"orderBy":""},
{"id":null,"columnName":"LIKELY_TO_RETURN","dataIndex":"likelytoReturn","columnVisibility":"HIDE","sequence":11,"mandatory":false,"defaultSortBy":false,"orderBy":""},
{"id":null,"columnName":"ADDED_STATUS","dataIndex":"addedStatus","columnVisibility":"SHOW","sequence":12,"mandatory":false,"defaultSortBy":null,"orderBy":""},
{"id":null,"columnName":"STUDENT_JOURNEY_ATTRIBUTE_VALUE","dataIndex":"attributeValue","columnVisibility":"SHOW","sequence":13,"mandatory":false,"defaultSortBy":null,"orderBy":""}]'
where gridName='Academia.view.personinfo.common.personalinfo.StudentJourneyCoreERPGrid' and portalId=1;
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'STUDENT_JOURNEY_ATTRIBUTE_VALUE')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'STUDENT_JOURNEY_ATTRIBUTE_VALUE', 'Attribute Value', 'Attribute Value','Eienskapwaarde','Giá trị thuộc tính',now(),1);
END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250102120220__Update_StudentJourneyCoreERPGrid () $$
DROP PROCEDURE IF EXISTS V20250102120220__Update_StudentJourneyCoreERPGrid $$
DELIMITER ;