DELIMITER $$
DROP PROCEDURE IF EXISTS V20250120163011__Create_UTMTranscriptReport $$
CREATE PROCEDURE V20250120163011__Create_UTMTranscriptReport()
BEGIN

set @utm = (select max(id) from report_type where typeName='Mark Sheet');
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'UTM_TRANSCRIPT')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`,`documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@utm, 'UTM_TRANSCRIPT', 'UTM Transcript', 'UTM_TRANSCRIPT.png', 'CommonReport_UTM_TRANSCRIPT.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'UTM_TRANSCRIPT.jasper', 'AcademiaLogo.png');
END IF; 


IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'UTM_TRANSCRIPT')) THEN 
set @H1 = (select max(id)  from report_template where templateCode ='UTM_TRANSCRIPT');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_FINAL_TRANSCRIPT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_FINAL_TRANSCRIPT', 'Final Transcript', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SCHOOL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SCHOOL', 'School', '1', now());
END IF;
 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NAME', 'Name', '1', now());
END IF;
 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_STUDENT_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_STUDENT_ID', 'Student ID', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_INTAKE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_INTAKE', 'Intake', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_PROGRAM_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_PROGRAM_NAME', 'Programme Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_PROGRAM_MODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_PROGRAM_MODE', 'Programme Mode', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_PROGRAM_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_PROGRAM_CODE', 'Programme Code', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_COURCE_LEVEL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_COURCE_LEVEL', 'Course Level', '1', now());
END IF;
 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_PERIOD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_PERIOD', 'Period', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_DATE_PRINTED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_DATE_PRINTED', 'Date Printed', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SEMESTER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SEMESTER', 'Semester', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_MODULE_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_MODULE_NAME', 'Module Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_MODULE_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_MODULE_CODE', 'Module Code', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_MARKS100')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_MARKS100', 'Marks (100%)', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_CREDITS_TAKEN')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_CREDITS_TAKEN', 'Credits Taken', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_CREDITS_EARNED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_CREDITS_EARNED', 'Credits Earned', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_GRADE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_GRADE', 'Grade', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_REMARK')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_REMARK', 'Remarks', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_OVERALL_PROFORMANCE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_OVERALL_PROFORMANCE', 'Overall Performance', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SPA')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SPA', 'SPA', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_TOTAL_CRD_ERN')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_TOTAL_CRD_ERN', 'Total Credits Earned', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_FINAL_CPA')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_FINAL_CPA', 'Final CPA(%)', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_MODULE_GRADE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_MODULE_GRADE', 'Module Grade', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_AWARD_CLASS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_AWARD_CLASS', 'Award Classification', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY', 'This is a computer-generated document and requires no authentication.', '1', now());
END IF;

END $$
CALL V20250120163011__Create_UTMTranscriptReport () $$ 
DROP PROCEDURE IF EXISTS V20250120163011__Create_UTMTranscriptReport $$ 
DELIMITER ;