DELIMITER $$
DROP PROCEDURE IF EXISTS V20250121111247__Create_PaytmChildGrid $$
CREATE PROCEDURE V20250121111247__Create_PaytmChildGrid()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='paytm')) THEN 
CREATE TABLE `paytm` (
  		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
        `academyLocationId` BIGINT(20) NOT NULL,
  		`paytmEnvironment` varchar(255) NOT NULL,
        `paytmMId` varchar(255) NOT NULL,
         `paytmMerchantKey` varchar(255) NOT NULL,
         `paytmWebsite` varchar(255) NOT NULL,
         `currencyCode` varchar(255) NOT NULL,
         `transactionStatusURL` varchar(700) NOT NULL,
         `transactionURL` varchar(700) NOT NULL,
         `industryType` varchar(255) NOT NULL,
		`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		`lastUpdatedBy` bigint(20) NOT NULL,
         PRIMARY KEY (`id`),
		 INDEX `fk_academylocationid_idx` (`academyLocationId` ASC),
		INDEX `fk_paytm_child_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
            CONSTRAINT `fk_academylocationid_ids`
		    FOREIGN KEY (`academyLocationId`)
		    REFERENCES `academy_location` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT,
	  	CONSTRAINT `fk_paytm_child_lastUpdatedBy_user_id_idx`
		    FOREIGN KEY (`lastUpdatedBy`)
		    REFERENCES `users` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT
		) ;
END IF; 
   IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'paytm')) THEN 
  SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@standardMasterMaxId+1, 'paytm','PAYTM','Payment Gateway','MASTER_WITH_AL',1,0,1,SYSDATE());
        SET SQL_SAFE_UPDATES = 0;
		SET @standardMasterId=(SELECT id FROM standard_master WHERE `tableName`='paytm');
		UPDATE `standard_master` SET `childMaster`=@standardMasterId, `whetherParent`=1 WHERE `tableName`='standard_payment_gateway';
		INSERT INTO standard_payment_gateway (itemCode,itemValue,activeStatus,lastUpdate,lastUpdatedBy)  VALUES (@standardMasterId,'Paytm',false,now(),1);
		SET SQL_SAFE_UPDATES = 1;
        SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`,`fkDisplayField`,`whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'academyLocation', 'ACADEMY_LOCATION', @standardMasterMaxId+1, 'Varchar', '1', 1,'academy_location', 'id','academyLocationName' ,0, 0, 0, '1',SYSDATE());
        SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'paytmEnvironment', 'PAYTM_ENVIRONMENT', @standardMasterMaxId+1, 'Varchar', '2', 0, 0, 0, 0, '1',SYSDATE());
        SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'paytmMId', 'PAYTM_MID', @standardMasterMaxId+1, 'Varchar', '3', 0, 0, 0, 0, '1',SYSDATE());
         SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'paytmMerchantKey', 'PAYTM_MERCHANT_KEY', @standardMasterMaxId+1, 'Varchar', '4', 0, 0, 0, 0, '1',SYSDATE());
        SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'paytmWebsite', 'PAYTM_WEBSITE', @standardMasterMaxId+1, 'Varchar', '5', 0, 0, 0, 0, '1',SYSDATE());
        SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'currencyCode', 'CURRENCY_CODE', @standardMasterMaxId+1, 'Varchar', '6', 0, 0, 0, 0, '1',SYSDATE());
        SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'transactionStatusURL', 'TRANSACTION_STATUS_URL', @standardMasterMaxId+1, 'Varchar', '7', 0, 0, 0, 0, '1',SYSDATE());
        SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'transactionURL', 'TRANSACTION_URL', @standardMasterMaxId+1, 'Varchar', '8', 0, 0, 0, 0, '1',SYSDATE());
        SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'industryType', 'INDUSTRY_TYPE', @standardMasterMaxId+1, 'Varchar', '9', 0, 0, 0, 0, '1',SYSDATE());
		
END IF;

END $$
CALL V20250121111247__Create_PaytmChildGrid () $$ 
DROP PROCEDURE IF EXISTS V20250121111247__Create_PaytmChildGrid $$ 
DELIMITER ;