DELIMITER $$
DROP PROCEDURE IF EXISTS V20250129125439__Update_CourseDataProvider $$
CREATE PROCEDURE V20250129125439__Update_CourseDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT id FROM dydt_data_provider WHERE `providerName`='COURSE_DATA_PROVIDER')) THEN 

SET @dataproviderId2=(SELECT id FROM dydt_data_provider WHERE `providerName`='COURSE_DATA_PROVIDER');
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT courseCode AS course_code,
	courseName AS course_name,
	courseShortName AS course_short_name,
	nameToBePrinted AS print_name,
	courseMarksGrades AS mark_grades,
	courseGradeType AS grade_type,
	courseShortDescription AS course_description,
	courseStage AS course_stage ,
	courseNameLanguageOne AS course_name_language_one,
	courseShortNameLanguageOne AS course_short_name_language_one,
	nameToBePrintedLanguageOne AS name_print_language_one,
	courseNameLanguageTwo AS course_name_language_two,
	courseShortNameLanguageTwo AS course_short_name_language_two,
	nameToBePrintedLanguageTwo AS name_print_language_two,
	courseNameLanguageThree AS course_name_language_three,
	courseShortNameLanguageThree AS course_short_name_language_three,
	nameToBePrintedLanguageThree AS name_print_language_three
	FROM courses c',
    
    `resultColumnsDef` = "course_code,course_name,course_short_name,print_name,mark_grades,grade_type,course_description,course_stage,
	course_name_language_one,course_short_name_language_one,name_print_language_one,course_name_language_two,course_short_name_language_two,
	name_print_language_two,course_name_language_three,course_short_name_language_three,name_print_language_three",
    `sqlWhereQueryDef` = "WHERE c.id=PRM_COURSE_ID"
WHERE
    `dataSourceCode` = "COURSE_INFO" AND dataProviderId = @dataproviderId2;


END IF;
SET SQL_SAFE_UPDATES=1;

IF EXISTS (SELECT id FROM `dydt_data_line_item` where dataSourceCode="COURSE_INFO") THEN

SET @dydtdatalinitemId=(SELECT id FROM `dydt_data_line_item` where dataSourceCode="COURSE_INFO");

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE translationCode = 'course_name_language_one' 
AND dataProviderLineItemId = @dydtdatalinitemId) THEN
INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) 
VALUES ('course_name_language_one', 'Course Name language 1', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE translationCode = 'course_short_name_language_one' 
AND dataProviderLineItemId = @dydtdatalinitemId) THEN
INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) 
VALUES ('course_short_name_language_one', 'Course Short name language 1', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE translationCode = 'name_print_language_one' 
AND dataProviderLineItemId = @dydtdatalinitemId) THEN
INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) 
VALUES ('name_print_language_one', 'Course print name language 1', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE translationCode = 'course_name_language_two' 
AND dataProviderLineItemId = @dydtdatalinitemId) THEN
INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) 
VALUES ('course_name_language_two', 'Course Name language 2', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE translationCode = 'course_short_name_language_two' 
AND dataProviderLineItemId = @dydtdatalinitemId) THEN
INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) 
VALUES ('course_short_name_language_two', 'Course Short name language 2', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE translationCode = 'name_print_language_two' 
AND dataProviderLineItemId = @dydtdatalinitemId) THEN
INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) 
VALUES ('name_print_language_two', 'Course print name language 2', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE translationCode = 'course_name_language_three' 
AND dataProviderLineItemId = @dydtdatalinitemId) THEN
INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) 
VALUES ('course_name_language_three', 'Course Name language 3', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE translationCode = 'course_short_name_language_three' 
AND dataProviderLineItemId = @dydtdatalinitemId) THEN
INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) 
VALUES ('course_short_name_language_three', 'Course Short name language 3', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE translationCode = 'name_print_language_three' 
AND dataProviderLineItemId = @dydtdatalinitemId) THEN
INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) 
VALUES ('name_print_language_three', 'Course print name language 3', @dydtdatalinitemId);
END IF;

END IF;

END $$
CALL V20250129125439__Update_CourseDataProvider () $$
DROP PROCEDURE IF EXISTS V20250129125439__Update_CourseDataProvider $$
DELIMITER ;