DELIMITER $$
DROP PROCEDURE IF EXISTS V20250226163244__Alter_AddColumnsInIncident $$
CREATE PROCEDURE V20250226163244__Alter_AddColumnsInIncident()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'incidents' AND COLUMN_NAME = 'courseVarientId') THEN
    ALTER TABLE incidents
    ADD COLUMN courseVarientId BIGINT DEFAULT NULL;
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.referential_constraints WHERE constraint_schema = DATABASE() AND TABLE_NAME = 'incidents' AND CONSTRAINT_NAME = 'FK_course_varient') THEN
    ALTER TABLE incidents
    ADD CONSTRAINT FK_course_varient FOREIGN KEY (courseVarientId) REFERENCES course_variants(id);
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'incidents' AND COLUMN_NAME = 'outcomeId') THEN
    ALTER TABLE incidents
    ADD COLUMN outcomeId BIGINT DEFAULT NULL;
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.referential_constraints WHERE constraint_schema = DATABASE() AND TABLE_NAME = 'incidents' AND CONSTRAINT_NAME = 'FK_outcome') THEN
    ALTER TABLE incidents
    ADD CONSTRAINT FK_outcome FOREIGN KEY (outcomeId) REFERENCES outcome_csm(id);
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'incidents' AND COLUMN_NAME = 'penaltyId') THEN
    ALTER TABLE incidents
    ADD COLUMN penaltyId BIGINT DEFAULT NULL;
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.referential_constraints WHERE constraint_schema = DATABASE() AND TABLE_NAME = 'incidents' AND CONSTRAINT_NAME = 'FK_penalty') THEN
    ALTER TABLE incidents
    ADD CONSTRAINT FK_penalty FOREIGN KEY (penaltyId) REFERENCES penalty_csm(id);
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'incidents' AND COLUMN_NAME = 'dynamicEventId') THEN
    ALTER TABLE incidents
    ADD COLUMN dynamicEventId BIGINT DEFAULT NULL;
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.referential_constraints WHERE constraint_schema = DATABASE() AND TABLE_NAME = 'incidents' AND CONSTRAINT_NAME = 'FK_dynamicEvent') THEN
    ALTER TABLE incidents
    ADD CONSTRAINT FK_dynamicEvent FOREIGN KEY (dynamicEventId) REFERENCES exam_event_detail(id);
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'incidents' AND COLUMN_NAME = 'nonDynamicEventId') THEN
    ALTER TABLE incidents
    ADD COLUMN nonDynamicEventId BIGINT DEFAULT NULL;
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.referential_constraints WHERE constraint_schema = DATABASE() AND TABLE_NAME = 'incidents' AND CONSTRAINT_NAME = 'FK_nonDynamicEvent') THEN
    ALTER TABLE incidents
    ADD CONSTRAINT FK_nonDynamicEvent FOREIGN KEY (nonDynamicEventId) REFERENCES eval_seq_detail(id);
END IF;

END $$
CALL V20250226163244__Alter_AddColumnsInIncident() $$
DROP PROCEDURE IF EXISTS V20250226163244__Alter_AddColumnsInIncident $$
DELIMITER ;