DELIMITER $$

DROP PROCEDURE IF EXISTS V20250227155710__Create_Room_and_Staff_Allocation_Data_Grid $$

CREATE PROCEDURE V20250227155710__Create_Room_and_Staff_Allocation_Data_Grid()
BEGIN
	SET SQL_SAFE_UPDATES=0;
    IF NOT EXISTS (SELECT * FROM data_grid 
                   WHERE gridName = 'Academia.view.examinationcenters.assessmentEvent.RoomAndStaffAllocationGrid' 
                   AND portalId = 1) 
    THEN 
        INSERT INTO `data_grid` (`gridName`, `portalId`, `jsonObject`, `lastUpdate`, `lastUpdatedBy`) 
        VALUES 
        ('Academia.view.examinationcenters.assessmentEvent.RoomAndStaffAllocationGrid', 1,
        '[{"id":null, "columnName":"COURSE_CODE_NAME", "dataIndex":"courseName", "columnVisibility":"SHOW", "sequence":1, "mandatory":false}, 
          {"id":null, "columnName":"DETAILED_SEQUENCE", "dataIndex":"eventName", "columnVisibility":"SHOW", "sequence":2, "mandatory":false}, 
          {"id":null, "columnName":"DATE", "dataIndex":"printDate", "columnVisibility":"SHOW", "sequence":3, "mandatory":false}, 
          {"id":null, "columnName":"TIME", "dataIndex":"time", "columnVisibility":"SHOW", "sequence":4, "mandatory":false}, 
          {"id":null, "columnName":"COURSE_ENROLLMENT_COUNT", "dataIndex":"courseEnrolmentCount", "columnVisibility":"SHOW", "sequence":5, "mandatory":false}, 
          {"id":null, "columnName":"EVENT_MAPPED_STUDENT", "dataIndex":"eventMappedStudent", "columnVisibility":"SHOW", "sequence":6, "mandatory":false}, 
          {"id":null, "columnName":"BUILDING", "dataIndex":"buildingName", "columnVisibility":"SHOW", "sequence":7, "mandatory":false}, 
          {"id":null, "columnName":"ROOM", "dataIndex":"resourceNameRoom", "columnVisibility":"SHOW", "sequence":8, "mandatory":false}, 
          {"id":null, "columnName":"ROOM_CAPACITY", "dataIndex":"roomCapacity", "columnVisibility":"SHOW", "sequence":9, "mandatory":false}, 
          {"id":null, "columnName":"STUDENT_ALLOCATION", "dataIndex":"studntRoomAllocation", "columnVisibility":"SHOW", "sequence":10, "mandatory":false}, 
          {"id":null, "columnName":"PRIMARY_INVIGILATOR", "dataIndex":"firstInvigilatorFirstName", "columnVisibility":"SHOW", "sequence":11, "mandatory":false}, 
          {"id":null, "columnName":"SECONDARY_INVIGILATOR", "dataIndex":"secondInivigilatorFirstName", "columnVisibility":"SHOW", "sequence":12, "mandatory":false}, 
          {"id":null, "columnName":"INVIGILATOR_3", "dataIndex":"thirdInivigilatorFirstName", "columnVisibility":"SHOW", "sequence":13, "mandatory":false}, 
          {"id":null, "columnName":"INVIGILATOR_4", "dataIndex":"fourthInivigilatorFirstName", "columnVisibility":"SHOW", "sequence":14, "mandatory":false}, 
          {"id":null, "columnName":"MAPPED_STUDENT", "dataIndex":"mappedCount", "columnVisibility":"SHOW", "sequence":15, "mandatory":false}, 
          {"id":null, "columnName":"PUBLISH_STATUS", "dataIndex":"publishStatus", "columnVisibility":"SHOW", "sequence":16, "mandatory":false}
        ]', NOW(), 1);
    END IF;
    SET SQL_SAFE_UPDATES=1;
END $$

CALL V20250227155710__Create_Room_and_Staff_Allocation_Data_Grid $$  

DROP PROCEDURE IF EXISTS V20250227155710__Create_Room_and_Staff_Allocation_Data_Grid $$

DELIMITER ;