DELIMITER $$
DROP PROCEDURE IF EXISTS fatchSponsorReceiptToBePushInXero $$
CREATE PROCEDURE fatchSponsorReceiptToBePushInXero(jobLastRunTimestamp timestamp)
BEGIN
SELECT 
    FUNC_INC_VAR_SESSION_REC() AS id,
    xUser.xeroContactId AS xeroContactId,
	null as academiaUserId,
    xUser.academiaSponsorId as academiaSponsorId,
    rec.amount AS unitAmount,
    rec.receiptNo AS receiptNumber,
	rec.id AS receiptHeaderId,
    curr.currencyCode AS currencyCode,
    rec.transactionDate AS transactionDate,
    rec.narration AS narration,
    rec.status AS receiptStatus,
    rec.academyLocationId AS academyLocationId,
    rec.cancellationDate AS cancellationDate,
    rec.cancellationNarration AS cancellationNarration,
    xeroRecMap.id as xeroRecDbId,
    depositedBank.bankCode as accountCode,
    xeroRecMap.createdDate as createdDate,
    rec.voucherMode as voucherMode
FROM
    xero_user_mapping AS xUser
        JOIN
	receipt_header as rec on (rec.sponsorId=xUser.academiaSponsorId and xUser.academyLocationId=rec.academyLocationId)
		LEFT JOIN
	bank as depositedBank on depositedBank.id=rec.depositedBank
        LEFT JOIN
    currency AS curr ON rec.currencyId = curr.id
        LEFT JOIN
    xero_receipt_mapping AS xeroRecMap ON (xeroRecMap.academiaReceiptHeaderId = rec.id and rec.academyLocationId =xeroRecMap.academyLocationId)
     LEFT JOIN
    drop_down AS drp ON (drp.type = 'XeroRetriggerMaxAttemptDays')
WHERE
    rec.amount IS NOT NULL AND (xeroRecMap.id IS NULL OR (xeroRecMap.error IS NOT NULL
        AND (xeroRecMap.createdDate + INTERVAL CAST(drp.value AS SIGNED) DAY)>=CURRENT_DATE));
END $$ 
DELIMITER ;