DELIMITER $$
DROP PROCEDURE IF EXISTS V20250327114019__Create_QrScannerPushNotificationForProgram $$
CREATE PROCEDURE V20250327114019__Create_QrScannerPushNotificationForProgram()
BEGIN

SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ATTENDANCE');
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+2,@parentcategoryId,'QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE', 'Qr Scanner Push Notification For Program Wise', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- DL data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE_DL', 'SQL');

-- Recipient Infor data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE_RCPNT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE_RCPNT');


-- The under sql code gives for the user distribution list ,this information can be fetched
SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE_RCPNT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

-- Setting the query for the Parent distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
   T3.id AS USER_ID
FROM
    student_program_attendance_details T1
    JOIN admission AS T2 ON T2.id = T1.admissionId
    JOIN users AS T3 ON T3.id = T2.studentId
WHERE 
    T1.attendanceId IN (namedParams) and T2.activeStatus=true
    AND NOT EXISTS (
        SELECT 1 
        FROM student_apply_hold_category H 
        WHERE H.studentId = T3.id) GROUP BY T3.id",NULL);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE_RCPNT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    f.id AS ID,
   	group_concat(distinct f.deviceTokenId) AS DEVICE_ID,
    'QR_SCANNER' AS MSG_CATEGORY
FROM
    fire_base_persons_info f 
WHERE
    f.userId IN (namedParams)",null);


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='QR_SCANNER_PUSH_NOTIFICATION_FOR_PROGRAM_WISE_RCPNT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Qr Scanner Push Notification For Program Wise',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Qr Scanner Push Notification For Program Wise',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1','English',1);

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+1,@msgtemplateconfigId+1,'6','Attendance QR Code is Available','Your attendance QR code is ready! Tap to scan now');


END $$
CALL V20250327114019__Create_QrScannerPushNotificationForProgram () $$ 
DROP PROCEDURE IF EXISTS V20250327114019__Create_QrScannerPushNotificationForProgram $$ 
DELIMITER ;