DELIMITER $$
DROP PROCEDURE IF EXISTS V20250327124936__Create_CreateUsersClickedActivities $$
CREATE PROCEDURE V20250327124936__Create_CreateUsersClickedActivities()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'users_clicked_activities' )) THEN 
CREATE TABLE `users_clicked_activities`(
`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
`currentUserId` BIGINT(20) NOT NULL,
`staffRecord` bigint(20) DEFAULT NULL,
`studentRecord` bigint(20) DEFAULT NULL,
`academyLocationId` bigint(20) NOT NULL,
`userGroup` varchar(255) DEFAULT NULL,
`itemPinStatus` boolean DEFAULT false,
`createdDate` datetime(6) NOT NULL,
`displayCode` varchar(255) DEFAULT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `users_clickedActivities_visitedUserId_FK` FOREIGN KEY (`staffRecord`) REFERENCES `staffs` (`userId`),
CONSTRAINT `users_clickedActivities_visitedStudentId_FK` FOREIGN KEY (`studentRecord`) REFERENCES `students` (`userId`),
CONSTRAINT `users_clickedActivities_academyLocationId_FK` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
CONSTRAINT `users_clickedActivities_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);
END IF; 
END $$
CALL V20250327124936__Create_CreateUsersClickedActivities () $$ 
DROP PROCEDURE IF EXISTS V20250327124936__Create_CreateUsersClickedActivities $$ 
DELIMITER ;