DELIMITER $$

DROP PROCEDURE IF EXISTS fetchSponsorInvoiceToBePushInXero $$

CREATE PROCEDURE fetchSponsorInvoiceToBePushInXero(jobLastRunTimestamp timestamp)
BEGIN
   SELECT 
    FUNC_INC_VAR_SESSION_REC() AS id,
    xUser.xeroContactId AS xeroContactId,
	xUser.academiaSponsorId as academiaSponsorId,
	null as academiaUserId,
    bill.totalAmount AS unitAmount,
    bill.billNo AS invoiceNumber,
	bill.id AS billHeaderId,
    curr.currencyCode AS currencyCode,
    bill.billingDate AS billingDate,
    bill.dueDate AS dueDate,
    bill.reasonForManualBill AS reason,
    bill.billStatus AS billStatus,
    bill.academyLocationId AS academyLocationId,
    bill.cancellationDate AS cancellationDate,
    bill.cancellationNarration AS cancellationNarration,
    bill.raiseBillCategory AS raiseBillCategory,
    xeroInvMap.id as xeroInvDbId,
    sps.vatNumber as accountCode,
    xeroInvMap.createdDate as createdDate,
	null AS lineAmount,
    null AS feeHeadName
FROM
    xero_user_mapping AS xUser
        JOIN
    bill_header AS bill ON (bill.sponsorId = xUser.academiaSponsorId
        AND bill.raiseBillCategory = 'BILL_RECEIVABLE' and xUser.academyLocationId=bill.academyLocationId)
        JOIN
	sponsors AS sps ON(bill.sponsorId=sps.id and sps.vatNumber is not null)
        LEFT JOIN
    currency AS curr ON bill.currencyId = curr.id
        LEFT JOIN
    xero_invoice_mapping AS xeroInvMap ON (xeroInvMap.academiaBillHeaderId = bill.id and bill.academyLocationId =xeroInvMap.academyLocationId)
		LEFT JOIN
    drop_down AS drp ON (drp.type = 'XeroRetriggerMaxAttemptDays')
WHERE
    bill.totalAmount IS NOT NULL AND (xeroInvMap.id IS NULL  OR (xeroInvMap.error IS NOT NULL
        AND (xeroInvMap.createdDate + INTERVAL CAST(drp.value AS SIGNED) DAY)>=CURRENT_DATE));
END $$

DELIMITER ;
