DELIMITER $$
DROP PROCEDURE IF EXISTS V20250416134353__Create_MapAllRemarksToAllAcademyLocations $$
CREATE PROCEDURE V20250416134353__Create_MapAllRemarksToAllAcademyLocations()
BEGIN
    IF EXISTS (SELECT * FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = 'event_remark_academy_location_mapping') THEN
        INSERT INTO event_remark_academy_location_mapping (remarkId, academyLocationId, lastUpdatedBy)
        SELECT er.id AS remarkId, al.id AS academyLocationId, 1 AS lastUpdatedBy
        FROM event_level_remarks er
        CROSS JOIN academy_location al
        WHERE NOT EXISTS (
            SELECT 1
            FROM event_remark_academy_location_mapping erm
            WHERE erm.remarkId = er.id AND erm.academyLocationId = al.id
        );
END IF;

END $$

CALL V20250416134353__Create_MapAllRemarksToAllAcademyLocations() $$
DROP PROCEDURE IF EXISTS V20250416134353__Create_MapAllRemarksToAllAcademyLocations $$
DELIMITER ;
