DROP procedure IF EXISTS `delete_bulk_application_optimized`;
DELIMITER $$
CREATE  PROCEDURE `delete_bulk_application_optimized`(applicationIds TEXT)
BEGIN
    DECLARE start_index INT DEFAULT 1;
    DECLARE end_index INT;
    DECLARE value VARCHAR(255);
  
    SET SQL_SAFE_UPDATES=0;
    SET FOREIGN_KEY_CHECKS=0; 
    
-- Temporary table creation  
    CREATE TEMPORARY TABLE temp_applications (applicationId BIGINT PRIMARY KEY);
    CREATE TEMPORARY TABLE temp_applicant_persons (applicantPersonId BIGINT PRIMARY KEY);
    CREATE TEMPORARY TABLE temp_application_programs (applicationProgramId BIGINT PRIMARY KEY);
    CREATE TEMPORARY TABLE temp_application_prog_stages (applicationProgStageId BIGINT PRIMARY KEY);
    CREATE TEMPORARY TABLE temp_receipts (receiptHeaderId BIGINT PRIMARY KEY);
    CREATE TEMPORARY TABLE temp_offline_payment_header (offlinePaymentHeaderId BIGINT PRIMARY KEY);

-- parsing application input ids into temp table
    WHILE start_index > 0 DO
        SET end_index = LOCATE(',', applicationIds, start_index);
        
        IF end_index > 0 THEN
            SET value = SUBSTRING(applicationIds, start_index, end_index - start_index);
            SET start_index = end_index + 1;
        ELSE
            SET value = SUBSTRING(applicationIds, start_index);
            SET start_index = 0;
        END IF;
        INSERT INTO temp_applications (applicationId) VALUES (CAST(value AS DECIMAL));
    END WHILE;

-- insert master ids into temp table to improve performance
    INSERT INTO temp_applicant_persons (applicantPersonId)
    select distinct a.applicantPersonId from application as a inner join temp_applications as ta on a.id = ta.applicationId;

    INSERT INTO temp_application_programs (applicationProgramId)
    select distinct ap.id from application_program as ap inner join temp_applications as ta on ap.applicationId = ta.applicationId;

    INSERT INTO temp_application_prog_stages (applicationProgStageId)
    select distinct aps.id from application_prog_stage as aps inner join temp_application_programs as tap on aps.applicationProgramId = tap.applicationProgramId;

    INSERT INTO temp_receipts (receiptHeaderId)
    select distinct rh.id FROM receipt_header as rh inner join temp_applications as ta on rh.applicantId = ta.applicationId;

    INSERT INTO temp_offline_payment_header (offlinePaymentHeaderId)
    select oph.id FROM offline_payment_header as oph inner join temp_applications as ta on oph.applicationId = ta.applicationId;

-- start deletion process
    DELETE apss from application_prog_stage_status as apss inner join temp_application_prog_stages as taps on apss.applicationProgramStageId = taps.applicationProgStageId;

    DELETE apsm from application_prog_stage_marks as apsm inner join temp_application_prog_stages as taps on apsm.applicationProgramStageId = taps.applicationProgStageId;

    DELETE acdl, ed, d from application_condition_doc_log as acdl
    inner join application_condition_log as acl on acdl.applicationConditionLogId=acl.id
    inner join documents as d on d.id=acdl.documentId
    inner join extended_documents as ed on ed.documentId=d.id
    inner join temp_applications as ta on acl.applicationId = ta.applicationId;

    DELETE acl, ac FROM application_condition_log as acl
    inner join application_condition as ac on acl.applicationConditionId=ac.id
    inner join temp_applications as ta on acl.applicationId = ta.applicationId;

    DELETE e2 from external_user_association as e1
    inner join user_login_history as e2 on e1.externalUserId=e2.externalUsersId
    inner join temp_applications as ta on e1.applicationId = ta.applicationId;

    DELETE afpd, afd FROM application_fee_plan_details as afpd
    inner join application_fee_details as afd on afpd.applicationFeeDetailId=afd.id
    inner join temp_applications as ta on afd.applicationId = ta.applicationId;

    DELETE  fad, fdm FROM fee_adjustment_details fad inner join fee_adjustment_master fdm
    on fdm.id=fad.adjustmentMasterId
    inner join receipt_header rh on rh.id=fdm.receiptHeaderId
    inner join temp_applications as ta on rh.applicantId = ta.applicationId;

    DELETE rpi FROM receipt_payment_instrument as rpi inner join temp_receipts as tr on rpi.receiptHeaderId = tr.receiptHeaderId;

    DELETE vd, rv, v from voucher_detail vd 
    inner join voucher v on v.id=vd.voucherId
    inner join receipt_voucher rv on v.id=rv.voucherId
    inner join temp_receipts as tr on rv.receiptHeaderId = tr.receiptHeaderId;

    DELETE rh FROM receipt_header as rh inner join temp_receipts as tr on rh.id = tr.receiptHeaderId;

    DELETE opi FROM offline_payment_instrument as opi inner join temp_offline_payment_header as toph on opi.offlinePaymentHeaderId = toph.offlinePaymentHeaderId;

    DELETE opd FROM offline_payment_document as opd inner join temp_offline_payment_header as toph on opd.offlinePaymentHeaderId = toph.offlinePaymentHeaderId;

    DELETE oph FROM offline_payment_header as oph inner join temp_offline_payment_header as toph on oph.id = toph.offlinePaymentHeaderId;

    DELETE vd, pv, v, ph from voucher_detail as vd 
    inner join voucher v on v.id=vd.voucherId
    inner join payment_voucher pv on v.id=pv.voucherId
    inner join payment_header ph on ph.id=pv.paymentHeaderId
    inner join temp_applications as ta on ph.applicantId = ta.applicationId;

    DELETE vd, bv, v, bh from voucher_detail as vd 
    inner join voucher v on v.id=vd.voucherId
    inner join bill_voucher bv on v.id=bv.voucherId
    inner join bill_header bh on bh.id=bv.billId
    inner join temp_applications as ta on bh.applicantId = ta.applicationId;

    DELETE  fad, fdm FROM fee_adjustment_details fad
    inner join fee_adjustment_master fdm on fdm.id=fad.adjustmentMasterId
    inner join bill_header bh on bh.id=fdm.billHeaderId
    inner join temp_applications as ta on bh.applicantId = ta.applicationId;

    DELETE asdm FROM applicant_student_discount_master as asdm inner join temp_applications as ta on asdm.applicantId = ta.applicationId;

    DELETE bdd FROM bill_fee_plan_rule_stage bfprs inner join bill_header bh on bfprs.billId=bh.id
    inner join bill_discount_details bdd on bdd.billFeePlanRuleStageId=bfprs.id
    inner join temp_applications as ta on bh.applicantId = ta.applicationId;

    DELETE bfprs FROM bill_fee_plan_rule_stage bfprs inner join bill_header bh on bfprs.billId=bh.id
    inner join temp_applications as ta on bh.applicantId = ta.applicationId;

    DELETE bh FROM bill_header as bh inner join temp_applications as ta on bh.applicantId = ta.applicationId;

    DELETE aps from application_prog_stage as aps inner join temp_application_prog_stages as taps on aps.id = taps.applicationProgStageId;

    DELETE ard, ed, d from application_required_documents as ard 
    inner join documents d on d.id=ard.documentId
    inner join extended_documents ed on ed.documentId=d.id
    inner join temp_applications as ta on ard.applicationId = ta.applicationId;

    DELETE ard FROM application_required_documents as ard inner join temp_applications as ta on ard.applicationId = ta.applicationId;

    DELETE aa FROM applicant_address as aa inner join temp_applicant_persons as tap on aa.applicantPersonId = tap.applicantPersonId;

    DELETE fpd FROM fee_payer_detail as fpd inner join temp_applicant_persons as tap on fpd.applicantPersonId = tap.applicantPersonId;

    DELETE e1, e2 from external_user_association as e1 
    inner join external_users e2 on e1.externalUserId=e2.id 
    inner join temp_applications as ta on e1.applicationId = ta.applicationId;

    DELETE aad FROM application_admission_detail as aad inner join temp_application_programs as tap on aad.applicationProgramId = tap.applicationProgramId;

    DELETE atime from application_timeline as atime inner join temp_applications as ta on atime.applicationId = ta.applicationId;

    DELETE ap from application_program as ap inner join temp_application_programs as tap on ap.id = tap.applicationProgramId;

    DELETE apr, ap FROM applicant_person_relationships as apr 
    inner join applicant_person as ap on apr.relatedApplicantPersonId=ap.id 
    inner join temp_applicant_persons as tap on apr.applicantPersonId = tap.applicantPersonId;

    DELETE  a, af from application a inner join application_form af on a.applicationFormId =af.id inner join temp_applications as ta on a.id = ta.applicationId;

    DELETE ei FROM economic_information as ei inner join temp_applicant_persons as tap on ei.applicant_person_id = tap.applicantPersonId;

    DELETE ap FROM applicant_person as ap inner join temp_applicant_persons as tap on ap.id = tap.applicantPersonId;

    DELETE a FROM application as a inner join temp_applications as ta on ta.applicationId = a.id;

    SET SQL_SAFE_UPDATES=1;
    SET FOREIGN_KEY_CHECKS=1;

-- Droping temporary tables
    DROP TEMPORARY TABLE IF EXISTS temp_applications;
    DROP TEMPORARY TABLE IF EXISTS temp_applicant_persons;
    DROP TEMPORARY TABLE IF EXISTS temp_application_programs;
    DROP TEMPORARY TABLE IF EXISTS temp_application_prog_stages;
    DROP TEMPORARY TABLE IF EXISTS temp_receipts;
    DROP TEMPORARY TABLE IF EXISTS temp_offline_payment_header;
END$$
DELIMITER ;