DELIMITER $$
DROP PROCEDURE IF EXISTS V20250512120802__Create_StudentPortalSubMenuConfiguration $$
CREATE PROCEDURE V20250512120802__Create_StudentPortalSubMenuConfiguration()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_portal_sub_menu_config')) THEN  
CREATE TABLE `student_portal_sub_menu_config` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `studentPortalMenuConfigurationId` bigint(20) NOT NULL,
  `moduleCode` VARCHAR(100) DEFAULT NULL,
  `moduleName` VARCHAR(100) DEFAULT NULL,
  `isVisiable` BIT(1) NOT NULL DEFAULT b'0',
  `sequence` INT NOT NULL DEFAULT 1,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
   KEY `fk_student_portal_sub_menu_updateby` (`lastUpdatedBy`),
  CONSTRAINT `fk_student_portal_sub_menu_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Fk_student_portal_menu_config` FOREIGN KEY (`studentPortalMenuConfigurationId`) REFERENCES `student_portal_menu_config` (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 


END $$
CALL V20250512120802__Create_StudentPortalSubMenuConfiguration () $$ 
DROP PROCEDURE IF EXISTS V20250512120802__Create_StudentPortalSubMenuConfiguration $$ 
DELIMITER ;