DELIMITER $$
DROP PROCEDURE IF EXISTS V20250514144425__Create_Create_ReqTypeProgramPeriodMapping $$
CREATE PROCEDURE V20250514144425__Create_Create_ReqTypeProgramPeriodMapping()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.tables 
               WHERE table_schema = DATABASE() 
               AND table_name = 'request_type_program_period_mapping') THEN 
    CREATE TABLE `request_type_program_period_mapping` (
        `id` BIGINT NOT NULL AUTO_INCREMENT,
        `programBatchPeriodConfigId` BIGINT NOT NULL,
        `requestTypeId` BIGINT NOT NULL,
        `batchId` BIGINT NOT NULL,
        `academyLocationId` BIGINT NOT NULL,
        `lastUpdatedBy` BIGINT NOT NULL,
        `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        
        INDEX `rtppm_lastUpdatedBy_idx` (`lastUpdatedBy`),
        INDEX `rtppm_programBatchPeriodConfigId_idx` (`programBatchPeriodConfigId`),
        INDEX `rtppm_requestTypeId_idx` (`requestTypeId`),
        INDEX `rtppm_batchId_idx` (`batchId`),
        INDEX `rtppm_academyLocationId_idx` (`academyLocationId`),
        
        CONSTRAINT `fk_rtp_programBatchPeriodConfigId`
            FOREIGN KEY (`programBatchPeriodConfigId`)
            REFERENCES `prog_batch_period_config` (`id`)
            ON DELETE NO ACTION
            ON UPDATE NO ACTION,
            
        CONSTRAINT `fk_rtp_requestTypeId`
            FOREIGN KEY (`requestTypeId`)
            REFERENCES `request_types` (`id`)
            ON DELETE NO ACTION
            ON UPDATE NO ACTION,
            
        CONSTRAINT `fk_rtp_batchId`
            FOREIGN KEY (`batchId`)
            REFERENCES `batches` (`id`)
            ON DELETE NO ACTION
            ON UPDATE NO ACTION,
            
        CONSTRAINT `fk_rtp_academyLocationId`
            FOREIGN KEY (`academyLocationId`)
            REFERENCES `academy_location` (`id`)
            ON DELETE NO ACTION
            ON UPDATE NO ACTION,
            
        CONSTRAINT `fk_rtp_lastUpdatedBy`
            FOREIGN KEY (`lastUpdatedBy`)
            REFERENCES `users` (`id`)
            ON DELETE NO ACTION
            ON UPDATE NO ACTION
    );
END IF;

END $$
CALL V20250514144425__Create_Create_ReqTypeProgramPeriodMapping () $$ 
DROP PROCEDURE IF EXISTS V20250514144425__Create_Create_ReqTypeProgramPeriodMapping $$ 
DELIMITER ;