DELIMITER $$
DROP PROCEDURE IF EXISTS V20250522131355__Create_CurriculumAccrediationMapping $$
CREATE PROCEDURE V20250522131355__Create_CurriculumAccrediationMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.tables    WHERE table_schema = DATABASE() AND table_name = 'curriculum_accrediation_mapping')) THEN 
CREATE TABLE `curriculum_accrediation_mapping` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `curriculumAccrediationId` BIGINT NOT NULL,
  `programId`  BIGINT NOT NULL,
  `startDate` DATE DEFAULT NULL,
  `endDate` DATE  DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  
  PRIMARY KEY (`id`),
  INDEX `fk_curriculum_accrediation_mapping_curriculumAccrediationId_idx` (`curriculumAccrediationId` ASC),
  INDEX `fk_curriculum_accrediation_mapping_programId_idx` (`programId` ASC),
  INDEX `fk_curriculum_accrediation_mapping_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
 

  CONSTRAINT `fk_program_initiative_mapping_curriculumAccrediationId`
    FOREIGN KEY (`curriculumAccrediationId`)
    REFERENCES `curriculum_accrediation` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,

CONSTRAINT `fk_curriculum_accrediation_mapping_programId`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,
    
  CONSTRAINT `fk_curriculum_accrediation_mapping_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION
    
) ;

END IF;

END $$
CALL V20250522131355__Create_CurriculumAccrediationMapping () $$ 
DROP PROCEDURE IF EXISTS V20250522131355__Create_CurriculumAccrediationMapping $$ 
DELIMITER ;