DELIMITER $$

DROP PROCEDURE IF EXISTS V20250620113900__Create_StudentCerftificatePeriodMapping $$

CREATE PROCEDURE V20250620113900__Create_StudentCerftificatePeriodMapping()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_print_certificate_periods') THEN
    CREATE TABLE `student_print_certificate_periods` (
      `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
      
      `periodId` BIGINT(20) NOT NULL,
      
      `certificateId` BIGINT(20) NOT NULL,
      
      `admissionId` BIGINT(20) NOT NULL, 
      
      `isPrintWordFile` BOOLEAN NOT NULL DEFAULT FALSE,
      
      `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      
      `lastUpdatedBy` BIGINT(20) NOT NULL,
      
      PRIMARY KEY (`id`),
      
      INDEX `idx_pbpc_id` (`periodId` ASC),
      INDEX `idx_certificate_id` (`certificateId` ASC),
      INDEX `idx_admission_id` (`admissionId` ASC),
      INDEX `idx_last_updated_by` (`lastUpdatedBy` ASC),
      
      CONSTRAINT `fk_student_print_certificate_periods_pbpc`
        FOREIGN KEY (`periodId`)
        REFERENCES `prog_batch_period_config` (`id`),
        
      CONSTRAINT `fk_student_print_certificate_periods_certificate`
        FOREIGN KEY (`certificateId`)
        REFERENCES `certificates` (`id`),
        
      CONSTRAINT `fk_student_print_certificate_periods_admission`
        FOREIGN KEY (`admissionId`)
        REFERENCES `admission` (`id`), -- UPDATED HERE: Changed from 'admissions' to 'admission'
        
      CONSTRAINT `fk_student_print_certificate_periods_lastUpdatedBy`
        FOREIGN KEY (`lastUpdatedBy`)
        REFERENCES `users` (`id`)
        
    );
END IF;

END $$

CALL V20250620113900__Create_StudentCerftificatePeriodMapping () $$

DROP PROCEDURE IF EXISTS V20250620113900__Create_StudentCerftificatePeriodMapping $$

DELIMITER ;