DELIMITER $$
DROP PROCEDURE IF EXISTS V20250708145407__Alter_transferCreditExternalInternal $$
CREATE PROCEDURE V20250708145407__Alter_transferCreditExternalInternal()
BEGIN

-- 1. Rename 'remark' to 'studentRemark' if 'remark' exists
  IF EXISTS (
    SELECT * FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'exam_transfer_credit'
      AND table_schema = DATABASE()
      AND COLUMN_NAME = 'remark'
  ) THEN
    ALTER TABLE `exam_transfer_credit`
      CHANGE COLUMN `remark` `studentRemark` VARCHAR(255) DEFAULT NULL;
  END IF;

  -- 2. Add 'facultyRemark' if not exists
  IF NOT EXISTS (
    SELECT * FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'exam_transfer_credit'
      AND table_schema = DATABASE()
      AND COLUMN_NAME = 'facultyRemark'
  ) THEN
    ALTER TABLE `exam_transfer_credit`
      ADD COLUMN `facultyRemark` VARCHAR(255) DEFAULT NULL AFTER `studentRemark`;
  END IF;

  -- 3. Add 'facultyApproverDate' if not exists
  IF NOT EXISTS (
    SELECT * FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'exam_transfer_credit'
      AND table_schema = DATABASE()
      AND COLUMN_NAME = 'facultyApproverDate'
  ) THEN
    ALTER TABLE `exam_transfer_credit`
      ADD COLUMN `facultyApproverDate` DATE DEFAULT NULL AFTER `facultyRemark`;
  END IF;

  -- 4. Add 'facultyApproverId' if not exists
  IF NOT EXISTS (
    SELECT * FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'exam_transfer_credit'
      AND table_schema = DATABASE()
      AND COLUMN_NAME = 'facultyApproverId'
  ) THEN
    ALTER TABLE `exam_transfer_credit`
      ADD COLUMN `facultyApproverId` BIGINT DEFAULT NULL AFTER `facultyApproverDate`;
  END IF;

  -- 5. Add FK for 'facultyApproverId' if not exists
  IF NOT EXISTS (
    SELECT * FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE
    WHERE TABLE_NAME = 'exam_transfer_credit'
      AND table_schema = DATABASE()
      AND COLUMN_NAME = 'facultyApproverId'
      AND REFERENCED_TABLE_NAME = 'users'
  ) THEN
    ALTER TABLE `exam_transfer_credit`
      ADD CONSTRAINT `fk_exam_transfer_credit_facultyApproverId`
        FOREIGN KEY (`facultyApproverId`) REFERENCES `users` (`id`) ON DELETE SET NULL;
  END IF;

  -- 6. Add index for 'facultyApproverId' if not exists
  IF NOT EXISTS (
    SELECT * FROM INFORMATION_SCHEMA.STATISTICS
    WHERE TABLE_NAME = 'exam_transfer_credit'
      AND table_schema = DATABASE()
      AND INDEX_NAME = 'fk_exam_transfer_credit_facultyApproverId_idx'
  ) THEN
    ALTER TABLE `exam_transfer_credit`
      ADD KEY `fk_exam_transfer_credit_facultyApproverId_idx` (`facultyApproverId`);
  END IF;

  -- 7. Add 'completionDate' if not exists
  IF NOT EXISTS (
    SELECT * FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'exam_transfer_credit'
      AND table_schema = DATABASE()
      AND COLUMN_NAME = 'completionDate'
  ) THEN
    ALTER TABLE `exam_transfer_credit`
      ADD COLUMN `completionDate` DATE DEFAULT NULL AFTER `facultyApproverId`;
  END IF;

END $$
CALL V20250708145407__Alter_transferCreditExternalInternal() $$
DROP PROCEDURE IF EXISTS V20250708145407__Alter_transferCreditExternalInternal $$
DELIMITER ;