DELIMITER $$

DROP PROCEDURE IF EXISTS V20250718171257__Update_InternalTransCreditDataGridCoreNew $$
CREATE PROCEDURE V20250718171257__Update_InternalTransCreditDataGridCoreNew()
BEGIN
    SET SQL_SAFE_UPDATES = 0;

    IF EXISTS ((SELECT * FROM data_grid WHERE gridName = "Academia.view.student.studentprofile.StudentInternalTransferCreditRequestGrid" AND portalId = 1)) THEN 
        UPDATE data_grid
        SET jsonObject = '[
            {"id":null,"columnName":"PERIOD","dataIndex":"programPeriodName","columnVisibility":"SHOW","sequence":1,"mandatory":false},
            {"id":null,"columnName":"COURSE_CODE","dataIndex":"courseCode","columnVisibility":"SHOW","sequence":2,"mandatory":false},
            {"id":null,"columnName":"COURSE_NAME","dataIndex":"courseName","columnVisibility":"SHOW","sequence":3,"mandatory":false},
            {"id":null,"columnName":"CREDITS","dataIndex":"courseCredit","columnVisibility":"SHOW","sequence":4,"mandatory":false},
            {"id":null,"columnName":"MARKS_OR_GRADE","dataIndex":"marksGrade","columnVisibility":"SHOW","sequence":5,"mandatory":false},
            {"id":null,"columnName":"EQUIVALENT_COURSE_CODE","dataIndex":"equivalentCourseCode","columnVisibility":"SHOW","sequence":6,"mandatory":true},
            {"id":null,"columnName":"EQUIVALENT_COURSE_NAME","dataIndex":"equivalentCourseName","columnVisibility":"SHOW","sequence":7,"mandatory":true},
            {"id":null,"columnName":"PROGRAM","dataIndex":"programName","columnVisibility":"SHOW","sequence":8,"mandatory":true},
            {"id":null,"columnName":"BATCH","dataIndex":"batchName","columnVisibility":"SHOW","sequence":9,"mandatory":true},
            {"id":null,"columnName":"TRANSFER_PERIOD","dataIndex":"transferProgramPeriodName","columnVisibility":"SHOW","sequence":10,"mandatory":true},
            {"id":null,"columnName":"INSTITUTE_NAME","dataIndex":"academyLocation","columnVisibility":"SHOW","sequence":11,"mandatory":false},
            {"id":null,"columnName":"EQUIVALENT_COURSE_CREDIT","dataIndex":"equivalentCourseCredit","columnVisibility":"SHOW","sequence":12,"mandatory":false},
            {"id":null,"columnName":"OBTAINED_MARKS_GRADES","dataIndex":"effectiveMarks","columnVisibility":"SHOW","sequence":13,"mandatory":false},
            {"id":null,"columnName":"STATUS","dataIndex":"applicantTransferCreditStatus","columnVisibility":"SHOW","sequence":14,"mandatory":false},
            {"id":null,"columnName":"STUDENT_REMARK","dataIndex":"studentRemark","columnVisibility":"SHOW","sequence":15,"mandatory":false},
            {"id":null,"columnName":"FACULTY_REMARK","dataIndex":"facultyRemark","columnVisibility":"SHOW","sequence":16,"mandatory":false},
            {"id":null,"columnName":"COMPLETION_DATE","dataIndex":"completionDate","columnVisibility":"SHOW","sequence":17,"mandatory":false},
            {"id":null,"columnName":"FACULTY_APPROVER_DATE","dataIndex":"facultyApproverDate","columnVisibility":"SHOW","sequence":18,"mandatory":false},
            {"id":null,"columnName":"FACULTY_APPROVER_NAME","dataIndex":"facultyApproverName","columnVisibility":"SHOW","sequence":19,"mandatory":false},
            {"id":null,"columnName":"EQUIVALENT_COURSE_SYLLABUS","dataIndex":"document","columnVisibility":"SHOW","sequence":20,"mandatory":false}
        ]' 
        WHERE gridName = "Academia.view.student.studentprofile.StudentInternalTransferCreditRequestGrid" 
          AND portalId = 1;
    END IF;
    SET SQL_SAFE_UPDATES = 1;
END $$

CALL V20250718171257__Update_InternalTransCreditDataGridCoreNew () $$

DROP PROCEDURE IF EXISTS V20250718171257__Update_InternalTransCreditDataGridCoreNew $$

DELIMITER ;