DELIMITER $$
DROP PROCEDURE IF EXISTS V20250723125408__Alter_sqlDtProviderSendStudentReceiptEvnt $$
CREATE PROCEDURE V20250723125408__Alter_sqlDtProviderSendStudentReceiptEvnt()
BEGIN

IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_PAYMENT_ACKNOWLEDGEMENT')) THEN 
  SET @dtproviderid = (SELECT id FROM dtprovider WHERE dataProviderName = 'STUDENT_PAYMENT_ACKNOWLEDGEMENT');
  Update sql_dtprovider set sqlQuery = "SELECT 
  RH.id as ID,
    P.emailId as EMAIL_ID,
    P.alternateEmailId as ALTERNATE_EMAIL_ID,
    P.printName AS PRINT_NAME,
    P.firstName AS FIRST_NAME,
    P.middleName AS MIDDLE_NAME,
    P.lastName AS LAST_NAME,
    U.code AS USER_CODE,
    RH.amount AS AMOUNT,
    RH.receiptNo AS RECEIPT_NO,
    RH.transactionDate AS TRANSACTION_DATE,
    FPM.paymentModeName AS PAYMENT_MODE_NAME
FROM 
    receipt_header RH
LEFT JOIN students S ON S.userId = RH.studentId
LEFT JOIN persons P ON P.id = S.personId
LEFT JOIN users U ON U.id = S.userId
LEFT JOIN receipt_payment_instrument RPI ON RPI.receiptHeaderId = RH.id
LEFT JOIN fee_payment_modes FPM ON FPM.id = RPI.paymentMode
WHERE 
    RH.id IN (namedParams)"  WHERE dataProviderId = @dtproviderid;
END IF; 

END $$
CALL V20250723125408__Alter_sqlDtProviderSendStudentReceiptEvnt() $$
DROP PROCEDURE IF EXISTS V20250723125408__Alter_sqlDtProviderSendStudentReceiptEvnt $$
DELIMITER ;