DELIMITER $$
DROP PROCEDURE IF EXISTS V20250811175340__Insert_FeePlanDFRAndTranslation $$
CREATE PROCEDURE V20250811175340__Insert_FeePlanDFRAndTranslation()
BEGIN

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'feeplandetailwin' and formFieldId = 'generateAllBillsForSchools' )) THEN 
INSERT INTO `form_field_info` 
(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, `formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
VALUES ('feeplandetailwin', 'generateAllBillsForSchools', 'generateAllBillsForSchools', 'checkbox', 0, 0, 1, now(), 'Generate all bills for school', 'Fee Plan', 'Create, Edit, and View', 'Generate all bills for school', 0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'feeplandetailwin' and formFieldId = 'billGenerationDate' )) THEN 
INSERT INTO `form_field_info` 
(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, `formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
VALUES ('feeplandetailwin', 'billGenerationDate', 'billGenerationDate', 'datefield', 0, 0, 1, now(), 'Bill Generation Date', 'Fee Plan', 'Create, Edit, and View', 'Bill Generation Date', 0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'feeplandetailwin' and formFieldId = 'whetherProrataBillingForSchool' )) THEN 
INSERT INTO `form_field_info` 
(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, `formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
VALUES ('feeplandetailwin', 'whetherProrataBillingForSchool', 'whetherProrataBillingForSchool', 'checkbox', 0, 0, 1, now(), 'Whether pro rata for school', 'Fee Plan', 'Create, Edit, and View', 'Whether pro rata for school', 0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'feeplandetailwin' and formFieldId = 'isBillCancelationOnDeletePersonCover' )) THEN 
INSERT INTO `form_field_info` 
(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, `formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
VALUES ('feeplandetailwin', 'isBillCancelationOnDeletePersonCover', 'isBillCancelationOnDeletePersonCover', 'checkbox', 0, 0, 1, now(), 'Bill cancellation after person covered removal', 'Fee Plan', 'Create, Edit, and View', 'Bill cancellation after person covered removal', 0);
END IF; 

IF NOT EXISTS (((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'GENERATE_ALL_BILLS_FOR_SCHOOL'))) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'GENERATE_ALL_BILLS_FOR_SCHOOL', 'Generate all bills for school', 'Generate all bills for school','Genereer alle rekeninge vir die skool','Tạo tất cả các hóa đơn cho trường học',now(),1);
END IF;

IF NOT EXISTS (((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'WHETHER_PRO_RATA_FOR_SCHOOL'))) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'WHETHER_PRO_RATA_FOR_SCHOOL', 'Whether pro rata for school', 'Whether pro rata for school','Of pro rata vir skool','Cho dù tỷ lệ cho trường học',now(),1);
END IF;

IF NOT EXISTS (((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'BILL_CANCELLATION_AFTER_PERSON_COVERED_REMOVAL'))) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'BILL_CANCELLATION_AFTER_PERSON_COVERED_REMOVAL', 'Bill cancellation after person covered removal', 'Bill cancellation after person covered removal','Rekeningkansellasie na verwydering van persoon wat gedek word','Hủy hóa đơn sau khi người được bảo hiểm bị loại bỏ',now(),1);
END IF;

IF NOT EXISTS (((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'BILL_GENERATION_DATE'))) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'BILL_GENERATION_DATE', 'Bill Generation Date', 'Bill Generation Date','Rekening Generasie Datum','Ngày tạo hóa đơn',now(),1);
END IF;

END $$
CALL V20250811175340__Insert_FeePlanDFRAndTranslation() $$
DROP PROCEDURE IF EXISTS V20250811175340__Insert_FeePlanDFRAndTranslation $$
DELIMITER ;