DELIMITER $$
DROP PROCEDURE IF EXISTS V20250820170432__Update_approveAdmissionWebSite_LogoUrl $$
CREATE PROCEDURE V20250820170432__Update_approveAdmissionWebSite_LogoUrl()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE dataProviderName="APPROVE_ADMISSION_APPLICANT_INFO")) THEN
SET @dtProviderId = (select id from dtprovider WHERE dataProviderName="APPROVE_ADMISSION_APPLICANT_INFO" limit 1);
SET @sqldtProviderId = (select id from sql_dtprovider WHERE dataProviderId=@dtProviderId limit 1);
UPDATE sql_dtprovider
SET
    sqlQuery = "SELECT T4.id AS ID,
    T3.salutationName AS SALUTATION_NAME,
    T2.firstName AS FIRST_NAME,
    T2.middleName AS MIDDLE_NAME,
    T2.lastName AS LAST_NAME,
    T2.emailId AS EMAIL_ID,
    T2.mobileNumber AS MOBILE_NO,
    T1.code as APPLICATION_CODE,
    T5.displayName AS ACADEMY_NAME_LOCATION,
    CONCAT(T7.addressText,\' \',T8.cityName,\', \',T9.countryName,\', \',T10.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    CONCAT(T7.phoneCountryCode,\'-\',T7.phoneAreaCode,T7.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T7.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T11.programName AS PROGRAM_NAME,
    T13.batchName AS BATCH_NAME,
    T17.code AS LOGIN_ID,
    CONVERT(FROM_BASE64(T17.passwordBase64) USING utf8) AS PASSWORD,
    (CASE
        WHEN
            T5.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    \'/\',
                    \'emailer/images/logo_default_image.png\')
        WHEN
            T5.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            \'https://www.serosoft.com/mailer/academiaerp_logo_red.png\\'
        ELSE CONCAT(org.orgUrl, \'/\', T5.logoUrl)
    END) AS LOGO_URL,
    (CASE
            WHEN
                T5.headerUrl IS NOT NULL
                    AND org.orgUrl IS NOT NULL
            THEN
                CONCAT(org.orgUrl, \'/\', T5.headerUrl)
            ELSE NULL
        END) AS HEADERURL,
    (CASE
            WHEN
                T5.footerUrl IS NOT NULL
                    AND org.orgUrl IS NOT NULL
            THEN
                CONCAT(org.orgUrl, \'/\', T5.footerUrl)
            ELSE NULL
        END) AS FOOTERURL,
        T7.websiteURL AS WEBSITEURL,
        T20.itemValue AS ACADEMIC_TERM,
        T5.academyName AS ACADEMY_NAME,
        T21.alternateEmailId AS ALTERNATE_MAIL_ID
    FROM
        application T1
            INNER JOIN
        applicant_person T2 ON T2.id = T1.applicantPersonId
            LEFT JOIN
        salutations T3 ON T3.id = T2.salutationId
            LEFT JOIN
        application_program T4 ON T4.applicationId = T1.id
            LEFT OUTER JOIN
        admission T16 ON T16.applicationProgramId = T4.id
            LEFT OUTER JOIN
        users T17 ON T17.id = T16.studentId
            LEFT OUTER JOIN
        academy_location T5 ON T5.id = T4.academyLocationId
            LEFT OUTER JOIN
        academy_location_addresses T6 ON T6.academyLocationId = T5.id
            LEFT OUTER JOIN
        address T7 ON T7.id = T6.addressId
            && T7.addressTypeId = 10
            LEFT OUTER JOIN
        locations loc ON loc.id = T5.locationId
            LEFT OUTER JOIN
        location_addresses locadd ON locadd.locationId = loc.id
            LEFT JOIN
        address T21 ON T21.id = locadd.addressId
            LEFT OUTER JOIN
        city T8 ON T8.id = T7.cityId
            LEFT OUTER JOIN
        country T9 ON T9.id = T8.countryId
            LEFT OUTER JOIN
        country_region T10 ON T10.id = T8.countryRegionId
            LEFT OUTER JOIN
        programs T11 ON T11.id = T4.programId
            INNER JOIN
        prog_batch_seat_config ON prog_batch_seat_config.id = T4.progBatchSeatConfigId
            LEFT JOIN
        batches T13 ON T13.id = prog_batch_seat_config.programBatchId
            LEFT JOIN
        external_user_association T14 ON T14.applicationId = T1.id
            LEFT JOIN
        external_users T15 ON T15.id = T14.externalUserId
            LEFT OUTER JOIN
        organizations org ON org.id = (SELECT
                MAX(id)
            FROM
                organizations)
            LEFT OUTER JOIN
        program_batch_students T18 ON T18.admissionId = T16.id
            LEFT OUTER JOIN
        prog_batch_period_config T19 ON T18.progBatchPeriodConfigId = T19.id
            LEFT OUTER JOIN
        academic_term T20 ON T20.id = T19.academicTermId
    WHERE
        T4.id IN (namedParams)
     GROUP BY T1.id",
    jsonString = '{
        "id": 1,
        "searchResultViewColumns": [
            {
                "id": 1,
                "value": "id",
                "resultKey": "ID",
                "displayCode": "",
                "displayOrder": 0
            },
            {
                "id": 2,
                "value": "salutationName",
                "resultKey": "SALUTATION_NAME",
                "displayCode": "",
                "displayOrder": 1
            },
            {
                "id": 3,
                "value": "firstName",
                "resultKey": "FIRST_NAME",
                "displayCode": "",
                "displayOrder": 2
            },
            {
                "id": 4,
                "value": "middleName",
                "resultKey": "MIDDLE_NAME",
                "displayCode": "",
                "displayOrder": 3
            },
            {
                "id": 5,
                "value": "lastName",
                "resultKey": "LAST_NAME",
                "displayCode": "",
                "displayOrder": 4
            },
            {
                "id": 6,
                "value": "emailId",
                "resultKey": "EMAIL_ID",
                "displayCode": "",
                "displayOrder": 5
            },
            {
                "id": 7,
                "value": "mobileNumber",
                "resultKey": "MOBILE_NO",
                "displayCode": "",
                "displayOrder": 6
            },
            {
                "id": 8,
                "value": "code",
                "resultKey": "APPLICATION_CODE",
                "displayCode": "",
                "displayOrder": 7
            },
            {
                "id": 9,
                "value": "logoUrl",
                "resultKey": "LOGO_URL",
                "displayCode": "",
                "displayOrder": 8
            },
            {
                "id": 10,
                "value": "displayName",
                "resultKey": "ACADEMY_NAME_LOCATION",
                "displayCode": "",
                "displayOrder": 9
            },
            {
                "id": 11,
                "value": "Academy Location Address",
                "resultKey": "ACADEMY_LOCATION_ADDRESS",
                "displayCode": "",
                "displayOrder": 10
            },
            {
                "id": 12,
                "value": "Academy Location Phone No.",
                "resultKey": "ACADEMY_LOCATION_PHONE_NO",
                "displayCode": "",
                "displayOrder": 11
            },
            {
                "id": 13,
                "value": "Academy Location Email Id",
                "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
                "displayCode": "",
                "displayOrder": 12
            },
            {
                "id": 14,
                "value": "Program Name",
                "resultKey": "PROGRAM_NAME",
                "displayCode": "",
                "displayOrder": 13
            },
            {
                "id": 15,
                "value": "Batch Name",
                "resultKey": "BATCH_NAME",
                "displayCode": "",
                "displayOrder": 14
            },
            {
                "id": 16,
                "value": "Login Id",
                "resultKey": "LOGIN_ID",
                "displayCode": "",
                "displayOrder": 15
            },
            {
                "id": 17,
                "value": "Password",
                "resultKey": "PASSWORD",
                "displayCode": "",
                "displayOrder": 16
            },
           {
                "id": 18,
                "value": "Website URL",
                "resultKey": "WEBSITEURL",
                "displayCode": "",
                "displayOrder": 17
            },
    {
                "id": 19,
                "value": "Header Url",
                "resultKey": "HEADERURL",
                "displayCode": "",
                "displayOrder": 18
            },
    {
                "id": 20,
                "value": "Footer Url",
                "resultKey": "FOOTERURL",
                "displayCode": "",
                "displayOrder": 19
            },
    {
                "id": 21,
                "value": "itemValue",
                "resultKey": "ACADEMIC_TERM",
                "displayCode": "",
                "displayOrder": 20
            },
    {
                "id": 22,
                "value": "academyName",
                "resultKey": "ACADEMY_NAME",
                "displayCode": "",
                "displayOrder": 21
            },
    {
                "id": 23,
                "value": "alternateEmailId",
                "resultKey": "ALTERNATE_MAIL_ID",
                "displayCode": "",
                "displayOrder": 22
    }
        ]
    }'
WHERE
    (id = @sqldtProviderId);

END IF;
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250820170432__Update_approveAdmissionWebSite_LogoUrl () $$
DROP PROCEDURE IF EXISTS V20250820170432__Update_approveAdmissionWebSite_LogoUrl $$
DELIMITER ;