DELIMITER $$
DROP PROCEDURE IF EXISTS V20250904161948__Update_Mother_Receipt_Acknowledgement $$
CREATE PROCEDURE V20250904161948__Update_Mother_Receipt_Acknowledgement()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS (select MAX(id) from dtprovider where dataProviderName="MOTHER_RECEIPT_ACKNOWLEDGEMENT_RCPNT") THEN 

SET @dtProviderId=(select MAX(id) from dtprovider where dataProviderName="MOTHER_RECEIPT_ACKNOWLEDGEMENT_RCPNT");
IF EXISTS (select id from sql_dtprovider where dataProviderId=@dtProviderId) THEN 
update sql_dtprovider set sqlQuery="SELECT 
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`printName` AS PRINT_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T7.`emailId` AS EMAIL_ID,
    T7.`mobileNumber` AS MOBILE_NO,
    T7.`mobileCountryCode` AS MOBILE_CODE,
    T1.`amount` AS TOTAL_AMOUNT,
    T6.`currencyCode` AS CURRENCY_CODE,
    T8.`code` AS STUDENT_ID,
    T9.`displayName` AS ACADEMY_NAME,
    T7.`printName` AS MOTHER_NAME,
    DATE_FORMAT(T1.`transactionDate`, '%d-%m-%Y') AS RECEIPT_DATE
    
FROM
    receipt_header T1
       LEFT JOIN
    students T2 ON T2.userId = T1.studentId
      LEFT JOIN
    users T8 ON T2.userId = T8.id
         LEFT JOIN
    persons T3 ON T3.id = T2.personId
        INNER JOIN
    academy_location T9 ON T9.id = T1.academyLocationId    
		LEFT JOIN
    person_relationships T5 ON T3.id = T5.personId
		LEFT JOIN
    persons T7 ON T5.relatedPersonId = T7.id
        LEFT JOIN
    salutations T4 ON T4.id = T3.salutationId
         LEFT JOIN
    currency T6 ON T6.id = T1.currencyId
		LEFT JOIN
    fire_base_persons_info f ON f.userId = T2.userId
WHERE
T1.id IN (namedParams) 
and T5.relationship='MOTHER' and T5.whetherDeleted=false group by T1.id",jsonString='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "Salutation Name",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "Print Name",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "First Name",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "Middle Name",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "Last Name",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "Amount",
            "resultKey": "TOTAL_AMOUNT",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "Receipt Currency",
            "resultKey": "CURRENCY_CODE",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "transactionDate",
            "resultKey": "RECEIPT_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "receiptNo",
            "resultKey": "RECEIPT_NO",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "Student ID",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "Academy Location Name",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "Mother Name",
            "resultKey": "MOTHER_NAME",
            "displayCode": "",
            "displayOrder": 12
        }
    ]
}'
where dataProviderId=@dtProviderId;  
END IF; 
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250904161948__Update_Mother_Receipt_Acknowledgement () $$
DROP PROCEDURE IF EXISTS V20250904161948__Update_Mother_Receipt_Acknowledgement $$
DELIMITER ;