DELIMITER $$
DROP PROCEDURE IF EXISTS V20250929171019__Create_proforma_invoice $$
CREATE PROCEDURE V20250929171019__Create_proforma_invoice()
BEGIN


IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='proforma_invoice')) THEN 
CREATE TABLE `proforma_invoice` (
  `id` BIGINT NOT NULL  AUTO_INCREMENT,
  `proformaInvoiceNo` VARCHAR(255) NOT NULL,
  `invoiceDate` DATE NOT NULL,
  `studentId` BIGINT NOT NULL,
  `invoiceAmount` double(20,2) NULL,
  `academyLocationId` BIGINT NOT NULL,
  `programBatchSeatConfigId` BIGINT NOT NULL,
  `programBatchPeriodConfigId` BIGINT NOT NULL,
  `documentId` bigint(20) Default Null,
  `documentName` varchar(255) Default Null,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  
  PRIMARY KEY (`id`),
  INDEX `fk_proforma_invoice_to_student_idx`(`studentId`),
  INDEX `fk_proforma_invoice_to_user_idx` (`lastUpdatedBy`) ,
  INDEX `fk_proforma_invoice_to_academyLocationId_idx` (`academyLocationId` ASC) ,
  INDEX `fk_proforma_invoice_prog_batch_seat_config_idx` (`programBatchSeatConfigId` ASC) ,
  INDEX `fk_proforma_invoice_prog_batch_period_config_idx` (`programBatchPeriodConfigId` ASC) ,
  
  CONSTRAINT `fk_proforma_invoice_idx` 
	FOREIGN KEY (`studentId`) 
	REFERENCES `students`(`userId`)
    ON DELETE RESTRICT
	ON UPDATE RESTRICT,
 
  CONSTRAINT `fk_proforma_invoice_to_user_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_proforma_invoice_prog_batch_seat_config_idx`
    FOREIGN KEY (`programBatchSeatConfigId`)
    REFERENCES `prog_batch_seat_config` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_proforma_invoice_prog_batch_period_config_idx`
    FOREIGN KEY (`programBatchPeriodConfigId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_proforma_invoice_to_academyLocationId_idx`
	FOREIGN KEY (`academyLocationId`)
	REFERENCES `academy_location` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION);

END IF; 


END $$
CALL V20250929171019__Create_proforma_invoice () $$ 
DROP PROCEDURE IF EXISTS V20250929171019__Create_proforma_invoice $$ 
DELIMITER ;