DELIMITER $$
DROP PROCEDURE IF EXISTS V20250929183353__Create_ReadmissionRequestDetailTemporary $$
CREATE PROCEDURE V20250929183353__Create_ReadmissionRequestDetailTemporary()
BEGIN

IF NOT EXISTS (( SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='readmission_request_details_temp')) THEN 
CREATE TABLE `readmission_request_details_temp` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `planningToChangeProgram` bit(1) DEFAULT NULL DEFAULT b'0',
  `programChangeMotivationDoc` varchar(255) DEFAULT NULL,
  `intendedALOfStudyId` bigint DEFAULT NULL,
  `intendedProgramOfStudyId` bigint DEFAULT NULL,
  `unRegAchievementReason` text,
  `unRegAchievementDoc` varchar(255) DEFAULT NULL,
  `assistanceReason` text,
  `assistanceDoc` varchar(255) DEFAULT NULL,
  `futureSucceedReason` text,
  `futureSucceedDoc` varchar(255) DEFAULT NULL,
  `proofOfPaymentDoc` varchar(255) DEFAULT NULL,
  `termsAndConditions` bit(1) DEFAULT NULL DEFAULT b'0',
  `studentId` bigint DEFAULT NULL,
  `admissionId` bigint DEFAULT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `readmission_req_temp_alId_FK` (`intendedALOfStudyId`),
  KEY `readmission_req_temp_programId_FK` (`intendedProgramOfStudyId`),
  KEY `readmission_req_studentId_FK` (`studentId`),
  KEY `readmission_req_admissionId_FK` (`admissionId`),
  KEY `readmission_req_temp_lastUpdatedBy_FK` (`lastUpdatedBy`),
  CONSTRAINT `readmission_req_temp_alId_FK` FOREIGN KEY (`intendedALOfStudyId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `readmission_req_temp_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `readmission_req_temp_programId_FK` FOREIGN KEY (`intendedProgramOfStudyId`) REFERENCES `programs` (`id`),
  CONSTRAINT `readmission_req_studentId_FK` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`),
  CONSTRAINT `readmission_req_admissionId_FK` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;
END IF; 
END $$
CALL V20250929183353__Create_ReadmissionRequestDetailTemporary () $$ 
DROP PROCEDURE IF EXISTS V20250929183353__Create_ReadmissionRequestDetailTemporary $$ 
DELIMITER ;