DELIMITER $$

DROP PROCEDURE IF EXISTS V20251007115904__Alter_Ceremony_ApprDate_EffecDate $$
CREATE PROCEDURE V20251007115904__Alter_Ceremony_ApprDate_EffecDate()
BEGIN
    -- Check if table 'ceremony' exists
    IF EXISTS (
        SELECT * 
        FROM information_schema.TABLES 
        WHERE table_schema = DATABASE() 
          AND table_name = 'ceremony'
    ) THEN 

        -- Add 'effectivePassoutDate' column if not exists
        IF NOT EXISTS (
            SELECT * 
            FROM information_schema.COLUMNS 
            WHERE table_schema = DATABASE() 
              AND table_name = 'ceremony' 
              AND column_name = 'effectivePassoutDate'
        ) THEN 
            ALTER TABLE ceremony 
            ADD COLUMN effectivePassoutDate DATE DEFAULT NULL;
        END IF;

        -- Add 'approvalDate' column if not exists
        IF NOT EXISTS (
            SELECT * 
            FROM information_schema.COLUMNS 
            WHERE table_schema = DATABASE() 
              AND table_name = 'ceremony' 
              AND column_name = 'approvalDate'
        ) THEN 
            ALTER TABLE ceremony 
            ADD COLUMN approvalDate DATE DEFAULT NULL;
        END IF;

    END IF;

END $$

CALL V20251007115904__Alter_Ceremony_ApprDate_EffecDate() $$
DROP PROCEDURE IF EXISTS V20251007115904__Alter_Ceremony_ApprDate_EffecDate $$
DELIMITER ;
