DELIMITER $$
DROP PROCEDURE IF EXISTS getSAGEReceiptsData $$
CREATE PROCEDURE `getSAGEReceiptsData` (
    IN academyLocationId BIGINT,
    IN studentCode varchar(50),
    IN applicationCode varchar(50),
    IN sponsor varchar(50),
    IN receiptFromDate DATETIME,
	IN receiptToDate DATETIME,
	IN creationFromDate DATETIME,
	IN creationToDate DATETIME,
	IN lastUpdatedFromDate DATETIME,
	IN lastUpdatedToDate DATETIME
)
BEGIN
    SELECT 
        MAX(rh.transactionDate) AS `receiptDateTemp`,
        MAX(u.code) AS `studentAccountNumber`,
        MAX(cc.itemCode) AS `costCenter`,
        MAX(rh.amount) AS `paymentAmount`,
        MAX(c.currencyCode) AS `currencyCodes`,
        MAX(rh.narration) AS `description`,
        MAX(rh.receiptNo) AS `paymentReference`,
        MAX(rh.status) AS `status`,
        MAX(rh.creationDateTime) AS `createdDate`,
        MAX(rh.lastUpdate) AS `updatedDate`,
        MAX(rh.externalReceiptNo) AS `externalReceiptNumber`,
        MAX(u.code) AS `studentCode`,
        MAX(applicant.code) AS `applicationCode`,
        MAX(spon.sponsorshipCode) AS `sponsor`,
        CASE 
            WHEN MAX(applicant.code) IS NOT NULL THEN MAX(appPerson.externalSysRefOne)
            WHEN MAX(u.code) IS NOT NULL THEN MAX(p.externalSysRefOne)
            ELSE NULL
        END AS `externalSystemReference1`,
        CASE 
            WHEN COUNT(bh.billNo) > 0 THEN GROUP_CONCAT(DISTINCT bh.billNo ORDER BY bh.billNo SEPARATOR ',')
            ELSE NULL
        END AS `billNoTemp`
        
    FROM receipt_header rh
    LEFT JOIN fee_adjustment_master fam ON rh.id = fam.receiptHeaderId
    LEFT JOIN fee_adjustment_details fad ON fam.id = fad.adjustmentMasterId
    LEFT JOIN bill_header bh ON fad.billHeaderId = bh.id
    LEFT JOIN students s ON rh.studentId = s.userId
    LEFT JOIN users u ON s.userId = u.id
    LEFT JOIN persons p ON s.personId = p.id
    LEFT JOIN sponsors spon ON rh.sponsorId = spon.id
    LEFT JOIN application applicant ON rh.applicantId = applicant.id
    LEFT JOIN applicant_person appPerson ON applicant.applicantPersonId = appPerson.id
    LEFT JOIN academy_location al ON rh.academyLocationId = al.id
    LEFT JOIN cost_centre cc ON rh.costCentreId = cc.id
    LEFT JOIN currency c ON rh.currencyId = c.id
    WHERE rh.amount > 0
      AND (academyLocationId IS NULL OR al.id = academyLocationId)
      AND (studentCode IS NULL OR u.code = studentCode)
      AND (applicationCode IS NULL OR applicant.code = applicationCode)
      AND (sponsor IS NULL OR spon.sponsorshipCode = sponsor)
      AND (receiptFromDate IS NULL OR rh.transactionDate >= receiptFromDate)
      AND (receiptToDate IS NULL OR rh.transactionDate <= receiptToDate)
      AND (creationFromDate IS NULL OR rh.creationDateTime >= creationFromDate)
      AND (creationToDate IS NULL OR rh.creationDateTime <= creationToDate)
      AND (lastUpdatedFromDate IS NULL OR rh.lastUpdate >= lastUpdatedFromDate)
      AND (lastUpdatedToDate IS NULL OR rh.lastUpdate <= lastUpdatedToDate)
    GROUP BY rh.id;
END$$

DELIMITER ;