DELIMITER $$
DROP PROCEDURE IF EXISTS V20251014183341__Update_PassoutLetterDynamicDocument $$
CREATE PROCEDURE V20251014183341__Update_PassoutLetterDynamicDocument()
BEGIN
SET SQL_SAFE_UPDATES=0;

SET @dataProviderId=(select MAX(id) from dydt_data_provider where  providerName='PROGRAM_GROUP_CATEGORY_DATA_PROVIDER_INFO');
SET @dydtdatalinitemId=(select Max(id) from dydt_data_line_item where  dataSourceCode='PASSOUT_LETTER' and dataProviderId = @dataProviderId);

IF  EXISTS ((select * from dydt_data_line_item where  dataSourceCode='PASSOUT_LETTER' AND dataProviderId = @dataProviderId )) THEN 
update dydt_data_line_item set resultColumnsDef  ='STUDENT_ID,STUDENT_PRINT_NAME,FIRST_NAME,MIDDLE_NAME,LAST_NAME,MOBILE_NO,EMAIL_ID,STUDENT_ADMITTED_PROGRAM_NAME,STUDENT_ADMITTED_PROGRAM_CODE,STUDENT_BATCH,STUDENT_GRADUATED_PERIOD_NAME,STUDENT_GRADUATED_ACADEMIC_TERM,ACADEMY_LOCATION_WEBSITE_URL,HEADER_IMAGE_URL,FOOTER_IMAGE_URL,ACADEMY_NAME,LOCATION_NAME,ACADEMY_LOCATION_DISPLAY_NAME,ACADEMY_LOCATION_EMAIL_ID,ACADEMY_LOCATION_PHONE_CODE,ACADEMY_LOCATION_PHONE_AREA_CODE,ACADEMY_LOCATION_PHONE_NO,ACADEMY_LOCATION_MOBILE_CODE,ACADEMY_LOCATION_MOBILE_NO,PROGRAM_GROUP,PROGRAM_CATEGORY'
, sqlSelectQueryDef =  "select DISTINCT 
    T1.id As ID ,
    T3.code AS STUDENT_ID,
    p.printName AS STUDENT_PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.middleName AS MIDDLE_NAME,
    p.lastName AS LAST_NAME,
    p.mobileNumber AS MOBILE_NO,
    p.emailId AS EMAIL_ID,
    T9.programNameToBePrint AS STUDENT_ADMITTED_PROGRAM_NAME,
    T9.programCode AS STUDENT_ADMITTED_PROGRAM_CODE,
    T10.printName AS STUDENT_BATCH,
    T12.printName AS STUDENT_GRADUATED_PERIOD_NAME,
    T13.itemValue AS STUDENT_GRADUATED_ACADEMIC_TERM, 
    T15.websiteURL AS ACADEMY_LOCATION_WEBSITE_URL,
    (CASE
        WHEN
            T5.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.headerUrl)
        ELSE NULL
    END) AS HEADER_IMAGE_URL,
    (CASE
        WHEN
            T5.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.footerUrl)
        ELSE NULL
    END) AS FOOTER_IMAGE_URL,
    T5.academyName AS ACADEMY_NAME,
    T5.locationName AS LOCATION_NAME,
    T5.displayName AS ACADEMY_LOCATION_DISPLAY_NAME,
    T8.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T8.phoneCountryCode AS ACADEMY_LOCATION_PHONE_CODE,
    T8.phoneAreaCode AS ACADEMY_LOCATION_PHONE_AREA_CODE,
    T8.phoneNo AS ACADEMY_LOCATION_PHONE_NO,
    T8.cellCountryCode AS ACADEMY_LOCATION_MOBILE_CODE,
    T8.cellNo AS ACADEMY_LOCATION_MOBILE_NO,
    pg.groupName as PROGRAM_GROUP,
	pc.categoryName as PROGRAM_CATEGORY
 FROM completions T1
	LEFT JOIN
     students T2 ON T2.userId = T1.studentId
    LEFT JOIN  
    persons p on p.id = T2.personId
	LEFT JOIN
    users T3 ON T2.userId = T3.id
    LEFT JOIN
	admission T4 on T4.id = T1.admissionId
    LEFT JOIN
    academy_location T5 on T5.id = T4.academyLocationId
    LEFT JOIN 
    locations T6 on T6.id = T5.locationId
    LEFT JOIN 
    location_addresses T7 on T7.locationId = T6.id
    LEFT JOIN 
    address T8 on T8.id = T7.addressId
    LEFT JOIN
    programs T9 on T9.id = T1.programId
    LEFT JOIN 
    program_group pg on pg.id=T9.programGroupId
    LEFT JOIN 
    program_category pc on pc.id=T9.programCategoryId
    LEFT JOIN 
    batches T10 on T10.id = T1.batchId
    LEFT JOIN 
    program_batch_students T11 on T11.id = T4.id
    LEFT JOIN 
    prog_batch_period_config T12 on T12.id = T11.progBatchPeriodConfigId
    LEFT JOIN 
    academic_term T13 on T13.id = T12.academicTermId
    LEFT JOIN    
    organizations org ON org.id = (SELECT max(id) FROM organizations)
    LEFT JOIN 
    organization_addresses T14 ON org.id=T14.organizationId
    LEFT JOIN 
    address T15 on T15.id = T14.addressId
    LEFT JOIN 
    address_type T16 ON T16.id=T8.addressTypeId" ,
    sqlWhereQueryDef='where T1.id in (PRM_STUDENT_ID) and T15.addressTypeId=1'
where dataSourceCode='PASSOUT_LETTER'  AND dataProviderId = @dataProviderId  ; 
END IF; 

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'STUDENT_ID' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('STUDENT_ID', 'Student Id', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'STUDENT_PRINT_NAME' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('STUDENT_PRINT_NAME', 'Student Print Name', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'FIRST_NAME' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('FIRST_NAME', 'First Name', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'MIDDLE_NAME' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('MIDDLE_NAME', 'Middle Name', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'LAST_NAME' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('LAST_NAME', 'Last Name', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'MOBILE_NO' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('MOBILE_NO', 'Mobile No', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'EMAIL_ID' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('EMAIL_ID', 'Email Id', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'STUDENT_ADMITTED_PROGRAM_NAME' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('STUDENT_ADMITTED_PROGRAM_NAME', 'Student Admitted Program Name', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'STUDENT_ADMITTED_PROGRAM_CODE' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('STUDENT_ADMITTED_PROGRAM_CODE', 'Student Admitted Program Code', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'STUDENT_BATCH' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('STUDENT_BATCH', 'Student Batch', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'STUDENT_GRADUATED_PERIOD_NAME' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('STUDENT_GRADUATED_PERIOD_NAME', 'Student Graduated Period Name', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'STUDENT_GRADUATED_ACADEMIC_TERM' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('STUDENT_GRADUATED_ACADEMIC_TERM', 'Student Graduated Academic Term', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'ACADEMY_LOCATION_WEBSITE_URL' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('ACADEMY_LOCATION_WEBSITE_URL', 'Academy Location Website URL', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'HEADER_IMAGE_URL' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('HEADER_IMAGE_URL', 'Header Image URL', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'FOOTER_IMAGE_URL' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('FOOTER_IMAGE_URL', 'Footer Image URL', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'ACADEMY_NAME' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('ACADEMY_NAME', 'Academy Name', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'LOCATION_NAME' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('LOCATION_NAME', 'Location Name', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'ACADEMY_LOCATION_DISPLAY_NAME' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('ACADEMY_LOCATION_DISPLAY_NAME', 'Academy Location Display Name', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'ACADEMY_LOCATION_EMAIL_ID' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('ACADEMY_LOCATION_EMAIL_ID', 'Academy Location Email Id', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'ACADEMY_LOCATION_PHONE_CODE' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('ACADEMY_LOCATION_PHONE_CODE', 'Academy Location Phone Code', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'ACADEMY_LOCATION_PHONE_AREA_CODE' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('ACADEMY_LOCATION_PHONE_AREA_CODE', 'Academy Location Phone Area Code', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'ACADEMY_LOCATION_PHONE_NO' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('ACADEMY_LOCATION_PHONE_NO', 'Academy Location Phone No', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'ACADEMY_LOCATION_MOBILE_CODE' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('ACADEMY_LOCATION_MOBILE_CODE', 'Academy Location Mobile Code', @dydtdatalinitemId);
END IF;

IF NOT EXISTS (SELECT 1 FROM `dydt_templateparams_translations` WHERE `translationCode` = 'ACADEMY_LOCATION_MOBILE_NO' and dataProviderLineItemId= @dydtdatalinitemId) THEN
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
    VALUES ('ACADEMY_LOCATION_MOBILE_NO', 'Academy Location Mobile No', @dydtdatalinitemId);
END IF;

SET SQL_SAFE_UPDATES=1;

END $$
CALL V20251014183341__Update_PassoutLetterDynamicDocument () $$
DROP PROCEDURE IF EXISTS V20251014183341__Update_PassoutLetterDynamicDocument $$
DELIMITER ;