DELIMITER $$
DROP PROCEDURE IF EXISTS netsuiteFetchUserToBePushed $$
CREATE PROCEDURE netsuiteFetchUserToBePushed()
BEGIN

SELECT 
    user.id AS id,
    user.code AS studentId,
    user.code AS externalId,
    'Individual' AS type,
    sal.salutationName AS prefix,
    stuPer.firstName AS firstName,
    stuPer.lastName AS lastName,
    stuPer.middleName AS middleName,
    stuPer.emailId AS email,
    stuPer.alternateEmailId AS altEmail,
    staffPerson.shortNameOtherLanguage AS salesRep,
    CONCAT(COALESCE(stuPer.alternateMobileCountryCode, ''),
            COALESCE(stuPer.alternateMobileNo, '')) AS altPhone,
    CONCAT(COALESCE(stuPer.mobileCountryCode, ''),
            COALESCE(stuPer.mobileNumber, '')) AS mobileNumber,
    'STUDENT-Closed Won' AS status,
    gen.itemValue AS gender,
    stuPer.birth_place AS placeOfBirth,
    nation.itemValue AS nationality,
    seat.seatNameOtherLanguage AS primaryCurrency,
    seat.seatNameOtherLanguage2 AS taxItem
FROM
    users AS user
        LEFT JOIN
        netsuite_create_customer_mapping nccmap on nccmap.academiaUserId=user.id
        inner join
    students AS stu ON stu.userId = user.id
        LEFT JOIN
    persons AS stuPer ON stuPer.id = stu.personId
        LEFT JOIN
	users AS advisor ON stuPer.advisorId = advisor.id
        LEFT JOIN
	staffs AS staff ON advisor.id = staff.userId
    LEFT JOIN
	persons AS staffPerson ON staff.personId = staffPerson.id
        LEFT JOIN
    gender AS gen ON gen.id = stuPer.genderId
        LEFT JOIN
    salutations sal ON sal.id = stuPer.salutationId
        LEFT JOIN
    nationalities nation ON nation.id = stuPer.nationalityId
        LEFT JOIN
    admission adm ON adm.studentId = stu.userId
        LEFT JOIN
    prog_batch_seat_config pbsc ON pbsc.id = adm.programBatchSeatConfigId
        LEFT JOIN
    seat_types seat ON seat.id = pbsc.seatTypeId
    WHERE nccmap.academiaUserId IS NULL
     and adm.activeStatus is true
    and user.status is true
GROUP BY user.id;

END $$ 
DELIMITER ;