DELIMITER $$
DROP PROCEDURE IF EXISTS V20251029155613__Add_whatsapp_config_item $$
CREATE PROCEDURE V20251029155613__Add_whatsapp_config_item()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF  EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'whatsapp_configuration');

INSERT INTO standard_master_items (dbFieldName,fieldLabel,standardMasterId,fieldType,emunType,diaplayOrder,
whetherForeignKey,fkTable,fkFieldName,fkDisplayField,whetherShortCode,whetherReadOnly,wheherNullable,
validationType,maxLength,minLength,lastUpdatedBy,lastUpdate)
VALUES ('whatsappSetupConfiguration','WHATSAPP_SETUP_CONFIGURATION_CODE',@standardMasterId,'Varchar',NULL,1,
1,'whatsapp_setup_configuration','id','itemCode',0,0,0,
NULL,NULL,NULL,1,now());

END IF; 

-- translations

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName = 'TRANSLATIONS' and keyName = 'WHATSAPP_SETUP_CONFIGURATION_CODE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
VALUES ('TRANSLATIONS', 'WHATSAPP_SETUP_CONFIGURATION_CODE', 'Whatsapp Setup Configuration Code', 'Whatsapp Setup Configuration Code',
null,null,now(),1);
END IF;
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251029155613__Add_whatsapp_config_item () $$
DROP PROCEDURE IF EXISTS V20251029155613__Add_whatsapp_config_item $$
DELIMITER ;