DELIMITER $$
DROP PROCEDURE IF EXISTS V20251103121326__Update_ReportTamplateSchoolAttaStartDate $$
CREATE PROCEDURE V20251103121326__Update_ReportTamplateSchoolAttaStartDate()
BEGIN
SET SQL_SAFE_UPDATES=0;
set @dataProviderId=(SELECT id FROM dtprovider where dataProviderName='ASSESSMENT_SELECTION_VELOCITY_RCPNT');
IF EXISTS ((SELECT id FROM sql_dtprovider WHERE dataProviderId=@dataProviderId)) THEN 
UPDATE `sql_dtprovider` SET `sqlQuery` = 'SELECT\n        T6.id AS ID,\n        T3.`salutationName` AS SALUTATION_NAME,\n        T2.`firstName` AS FIRST_NAME,\n        T2.`middleName` AS MIDDLE_NAME,\n        T2.`lastName` AS LAST_NAME,\n        T2.`emailId` AS EMAIL_ID,\n        T2.`mobileNumber` AS MOBILE_NO,\n        T2.`mobileCountryCode` AS MOBILE_CODE,\n        T5.`loginId` AS LOGIN_ID,\n        T15.`conditions` AS REJECTION_REMARK,\n        CONVERT( FROM_BASE64(T5.passwordBase64) USING UTF8) AS PASSWORD,\n        CONCAT(T9.addressText,\n                \' \',\n                T10.cityName,\n                \', \',\n                T11.countryName,\n                \', \',\n                T12.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,\n        DATE_FORMAT(T14.admissionOfferStartDate, \'%d-%m-%Y\') AS OFFER_LETTER_START_DATE,\n        DATE_FORMAT(T14.admissionOfferEndDate, \'%d-%m-%Y\') AS OFFER_LETTER_END_DATE,\n        \'APPLICANT\' AS USER_TYPE_KEY,\n        T18.programName AS PROGRAM,\n        T17.batchName AS INTAKE,\n        T19.itemValue AS INTAKE_YEAR,\n        ml.code AS LANGUAGE_KEY,\n        ml.itemValue AS CORRESPONDENCE_LANGUAGE,\n       T20.itemValue as CURRENT_ACTIVITY,\n       T21.groupName AS PROGRAM_GROUP_NAME,\n    T22.seatName AS SEAT_TYPE,\n    T9.websiteURL as ACADEMY_LOCATION_URL,\nDATE_FORMAT(apd.expiryDate,\'%d-%m-%Y\') AS OFFER_VALID_UNTIL,\nDATE_FORMAT(T6.schoolAttendanceStartDate,\'%d-%m-%Y\') AS SCHOOL_ATTENDANCE_START_DATE\n    FROM\n        `application` T1\n            INNER JOIN\n        `applicant_person` T2 ON T2.id = T1.applicantPersonId\n             LEFT JOIN\n         `current_activity` T20 ON T20.`id` = T2.`current_activity_id`\n            LEFT JOIN\n        `salutations` T3 ON T3.`id` = T2.`salutationId`\n            LEFT JOIN\n        `external_user_association` T4 ON T4.`applicationId` = T1.`id`\n            LEFT JOIN\n        `external_users` T5 ON T5.`id` = T4.`externalUserId`\n            LEFT JOIN\n        application_program T6 ON T6.applicationId = T1.id\n           LEFT JOIN\n        application_program_detail apd ON T6.id=apd.applicationProgramId\n            LEFT JOIN\n        academy_location T7 ON T7.id = T6.academyLocationId\n            LEFT JOIN\n        application_condition T15 ON T15.applicationId = T1.id\n            LEFT JOIN\n        academy_location_addresses T8 ON T8.academyLocationId = T7.id\n            LEFT OUTER JOIN\n        address T9 ON T9.id = T8.addressId\n            && T9.addressTypeId = 10\n            LEFT OUTER JOIN\n        city T10 ON T10.id = T9.cityId\n            LEFT OUTER JOIN\n        country T11 ON T11.id = T10.countryId\n            LEFT OUTER JOIN\n        country_region T12 ON T12.id = T10.countryRegionId\n            LEFT JOIN\n        program_selection_process T13 ON T13.programBatchSeatConfigId = T6.progBatchSeatConfigId\n            LEFT JOIN\n        prog_slctn_process_admisn_conf T14 ON T14.programSelectionProcessId = T13.id\n            INNER JOIN\n        prog_batch_seat_config T16 ON T16.id = T6.progBatchSeatConfigId\n            INNER JOIN\n        batches T17 ON T17.id = T16.programBatchId\n            INNER JOIN\n        programs T18 ON T18.id = T17.programId\n       LEFT JOIN\n           program_group T21 ON T21.id = T18.programGroupId\n            INNER JOIN\n        intake_year T19 ON T19.id = T17.intakeYearId\n            LEFT JOIN\n        multi_language ml ON ml.id = T2.correspondence_language\n            LEFT JOIN\n        seat_types T22 ON T22.id = T16.seatTypeId \n    WHERE \n       T6.id IN\n       (\n          namedParams\n       )', `jsonString` = '{\n        \"id\": 1,\n        \"searchResultViewColumns\": [\n            {\n                \"id\": 1,\n                \"value\": \"id\",\n                \"resultKey\": \"ID\",\n                \"displayCode\": \"\",\n                \"displayOrder\": 0\n            },\n            {\n                \"id\": 2,\n                \"value\": \"salutationName\",\n                \"resultKey\": \"SALUTATION_NAME\",\n                \"displayCode\": \"\",\n                \"displayOrder\": 1\n            },\n            {\n                \"id\": 3,\n                \"value\": \"firstName\",\n                \"resultKey\": \"FIRST_NAME\",\n                \"displayCode\": \"\",\n                \"displayOrder\": 2\n            },\n            {\n                \"id\": 4,\n                \"value\": \"middleName\",\n                \"resultKey\": \"MIDDLE_NAME\",\n                \"displayCode\": \"\",\n                \"displayOrder\": 3\n            },\n            {\n                \"id\": 5,\n                \"value\": \"lastName\",\n                \"resultKey\": \"LAST_NAME\",\n                \"displayCode\": \"\",\n                \"displayOrder\": 4\n            },\n            {\n                \"id\": 6,\n                \"value\": \"emailId\",\n                \"resultKey\": \"EMAIL_ID\",\n                \"displayCode\": \"\",\n                \"displayOrder\": 5\n            },\n            {\n                \"id\": 7,\n                \"value\": \"mobileNumber\",\n                \"resultKey\": \"MOBILE_NO\",\n                \"displayCode\": \"\",\n                \"displayOrder\": 6\n            },\n            {\n                \"id\": 8,\n                \"value\": \"mobile Code\",\n                \"resultKey\": \"MOBILE_CODE\",\n                \"displayCode\": \"\",\n                \"displayOrder\": 7\n            },\n            {\n                \"id\": 9,\n                \"value\": \"Login Id\",\n                \"resultKey\": \"LOGIN_ID\",\n                \"displayCode\": \"\",\n                \"displayOrder\": 8\n            },\n            {\n                \"id\": 10,\n                \"value\": \"Password\",\n                \"resultKey\": \"PASSWORD\",\n                \"displayCode\": \"\",\n                \"displayOrder\": 9\n            },\n            {\n                \"id\": 11,\n                \"value\": \"Academy Location Address\",\n                \"resultKey\": \"ACADEMY_LOCATION_ADDRESS\",\n                \"displayCode\": \"\",\n                \"displayOrder\": 10\n            },\n            {\n                \"id\": 12,\n                \"value\": \"Offer Letter Start Date\",\n                \"resultKey\": \"OFFER_LETTER_START_DATE\",\n                \"displayCode\": \"\",\n                \"displayOrder\": 11\n            },\n            {\n                \"id\": 13,\n                \"value\": \"Offer Letter End Date\",\n                \"resultKey\": \"OFFER_LETTER_END_DATE\",\n                \"displayCode\": \"\",\n                \"displayOrder\": 12\n            },      \n            {\n                \"id\": 14,\n                \"value\": \"Remarks\",\n                \"resultKey\": \"REJECTION_REMARK\",\n                \"displayCode\": \"\",\n                \"displayOrder\": 13\n            },\n    		 {\n    			\"id\": 15,\n    			\"value\": \"programName\",\n    			\"resultKey\": \"PROGRAM\",\n    			\"displayCode\": \"\",\n    			\"displayOrder\": 14\n    		},\n              {\n    			\"id\": 16,\n    			\"value\": \"batchName\",\n    			\"resultKey\": \"INTAKE\",\n    			\"displayCode\": \"\",\n    			\"displayOrder\": 15\n    		  },\n               {\n    			\"id\": 17,\n    			\"value\": \"itemValue\",\n    			\"resultKey\": \"INTAKE_YEAR\",\n    			\"displayCode\": \"\",\n    			\"displayOrder\": 16\n    		  },\n    		  {\n                  \"id\": 18,\n                  \"value\": \"correspondence_language\",\n                  \"resultKey\": \"CORRESPONDENCE_LANGUAGE\",\n                  \"displayCode\": \"\",\n                  \"displayOrder\": 17\n              },\n    		  {\n                   \"id\": 19,\n                   \"value\": \"itemValue\",\n                   \"resultKey\": \"CURRENT_ACTIVITY\",\n                   \"displayCode\": \"\",\n                   \"displayOrder\": 18\n               },\n               \n                {\n                   \"id\": 20,\n                   \"value\": \"groupName\",\n                   \"resultKey\": \"PROGRAM_GROUP_NAME\",\n                   \"displayCode\": \"\",\n                   \"displayOrder\": 19\n               },\n               {\n                   \"id\": 21,\n                   \"value\": \"seatName\",\n                   \"resultKey\": \"SEAT_TYPE\",\n                   \"displayCode\": \"\",\n                   \"displayOrder\": 20\n               },\n               {\n                   \"id\": 22,\n                   \"value\": \"websiteURL\",\n                   \"resultKey\": \"ACADEMY_LOCATION_URL\",\n                   \"displayCode\": \"\",\n                   \"displayOrder\": 21\n               }\n,\n               {\n                   \"id\": 23,\n                   \"value\": \"expiryDate\",\n                   \"resultKey\": \"OFFER_VALID_UNTIL\",\n                   \"displayCode\": \"\",\n                   \"displayOrder\": 22\n               }\n,\n	{\n                   \"id\": 24,\n                   \"value\": \"schoolAttendanceStartDate\",\n                   \"resultKey\": \"SCHOOL_ATTENDANCE_START_DATE\",\n                   \"displayCode\": \"\",\n                   \"displayOrder\": 22\n               }\n        ]\n    }'  WHERE dataProviderId=@dataProviderId;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251103121326__Update_ReportTamplateSchoolAttaStartDate () $$
DROP PROCEDURE IF EXISTS V20251103121326__Update_ReportTamplateSchoolAttaStartDate $$
DELIMITER ;