DELIMITER $$
DROP PROCEDURE IF EXISTS V20251124160751__Insert_Period_Enrollment_Lega_Reg_Setup $$
CREATE PROCEDURE V20251124160751__Insert_Period_Enrollment_Lega_Reg_Setup()
BEGIN

INSERT INTO term_wise_profile_link
(
    lastUpdate,
    lastUpdatedBy,
    isSelected,
    sequenceNo,
    linkName,
    termWiseProfileUpdateId
)
SELECT 
    NOW(),
    1,                      
    0,                         
    (
        SELECT COALESCE(MAX(sequenceNo), 0) + 1
        FROM term_wise_profile_link
        WHERE termWiseProfileUpdateId = twpu.id
    ),
    'Period Enrollment',
    twpu.id
FROM term_wise_profile_update twpu
WHERE twpu.registrationTermSetupDetailId 
  AND NOT EXISTS (
        SELECT 1 
        FROM term_wise_profile_link t
        WHERE t.termWiseProfileUpdateId = twpu.id
          AND t.linkName = 'Period Enrollment'
    );


END $$
CALL V20251124160751__Insert_Period_Enrollment_Lega_Reg_Setup() $$
DROP PROCEDURE IF EXISTS V20251124160751__Insert_Period_Enrollment_Lega_Reg_Setup $$
DELIMITER ;