DELIMITER $$
DROP PROCEDURE IF EXISTS V20251125184707__Create_CsmSportsType $$
CREATE PROCEDURE V20251125184707__Create_CsmSportsType()
BEGIN

IF NOT EXISTS ((SELECT  *  FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = 'csm_sports_types')) THEN 
CREATE TABLE `csm_sports_types` (
    `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `itemCode` VARCHAR(100) NOT NULL,
    `itemValue` VARCHAR(100) NULL,   -- OPTIONAL NOW
    `lastUpdatedBy` BIGINT(20) NOT NULL,
    `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP 
         ON UPDATE CURRENT_TIMESTAMP,

    PRIMARY KEY (`id`),

    UNIQUE KEY `itemCode_UNIQUE` (`itemCode`),

    KEY `fk_sports_types_lastUpdatedBy_idx` (`lastUpdatedBy`),

    CONSTRAINT `fk_sports_types_lastUpdatedBy`
        FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) 
ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

-- CSM Data

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId = (SELECT MAX(id) FROM standard_master);

-- ============================================================
-- CREATE MASTER: csm_sports_types
-- ============================================================
IF NOT EXISTS (
    (SELECT * FROM standard_master 
     WHERE tableName = 'csm_sports_types')
) THEN

INSERT INTO `standard_master`
(`id`, `childMaster`, `tableName`, `masterName`, `moduleName`, `filterCode`,
 `whetherChild`, `whetherParent`, `droolsAgenda`,
 `lastUpdatedBy`, `lastUpdate`) 
VALUES 
(@standardMasterMaxId + 1, NULL,
 'csm_sports_types', 'CSM_SPORTS_TYPES', 'Students', 'COMMON_MASTER',
 0, 0, NULL,
 1, @currentTimeStamp);

END IF;


-- ============================================================
-- INSERT CSM FIELDS
-- ============================================================
IF EXISTS (
    (SELECT * FROM standard_master 
     WHERE tableName = 'csm_sports_types')
) THEN

SET @standardMasterId = (
    SELECT id FROM standard_master 
    WHERE tableName = 'csm_sports_types'
);

-- ============================================================
-- FIELD 1 : SPORTS_TYPE  (Item Code)
-- ============================================================
IF NOT EXISTS (
    (SELECT * FROM standard_master_items 
     WHERE standardMasterId = @standardMasterId 
     AND fieldLabel = 'SPORTS_TYPE')
) THEN

INSERT INTO `standard_master_items`
(`dbFieldName`, `fieldLabel`, `standardMasterId`,
 `fieldType`, `emunType`, `diaplayOrder`,
 `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`,
 `whetherShortCode`, `whetherReadOnly`, `wheherNullable`,
 `validationType`, `maxLength`, `minLength`,
 `lastUpdatedBy`, `lastUpdate`)
VALUES
('code', 'SPORTS_TYPE', @standardMasterId,
 'Varchar', NULL, 1,
 0, NULL, NULL, NULL,
 0, 0, 0,
 NULL, NULL, NULL,
 1, NOW());

END IF;


-- ============================================================
-- FIELD 2 : ACADEMY_LOCATION (Item Value)
-- ============================================================
IF NOT EXISTS ((SELECT * FROM standard_master_items where standardMasterId = @standardMasterId AND dbFieldName='academyLocation'))THEN 
	INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
	VALUES ('academyLocation','ACADEMY_LOCATION',@standardMasterId,'multiselectcombofield',NULL,2,NULL,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

-- ------------------TRANSLATION-------------------------------------------------

IF NOT EXISTS (select * from ui_translation where ui_translation.objectName='TRANSLATIONS' and keyName='SPORTS_TYPE') THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`, `lastUpdatedBy`) 
VALUES ( 'TRANSLATIONS', 'SPORTS_TYPE', 'Sports Type','Sports Type','Sport tipe','Loại thể thao', now(), '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'CSM_SPORTS_TYPES')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'CSM_SPORTS_TYPES', 'Sports Types', 'Sports Types','T hemp grootte','Kích cỡ áo phông',now(),1);
END IF; 
END IF; 

END $$
CALL V20251125184707__Create_CsmSportsType () $$ 
DROP PROCEDURE IF EXISTS V20251125184707__Create_CsmSportsType $$ 
DELIMITER ;