DELIMITER $$
DROP PROCEDURE IF EXISTS V20251125190421__Create_SportsTypeAcademyLocation $$
CREATE PROCEDURE V20251125190421__Create_SportsTypeAcademyLocation()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema = DATABASE() AND table_name = 'sports_type_academy_location')) THEN 
CREATE TABLE `sports_type_academy_location` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `sportsTypeId` BIGINT(20) NOT NULL,
  `academyLocationId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,

  PRIMARY KEY (`id`),

  INDEX `FK_sports_type_idx` (`sportsTypeId` ASC),
  INDEX `FK_sports_type_academy_location_idx` (`academyLocationId` ASC),
  INDEX `FK_sports_type_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),

  CONSTRAINT `FK_sports_type`
    FOREIGN KEY (`sportsTypeId`)
    REFERENCES `csm_sports_types` (`id`),

  CONSTRAINT `FK_sports_type_academy_location`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`),

  CONSTRAINT `FK_sports_type_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
);
END IF; 

END $$
CALL V20251125190421__Create_SportsTypeAcademyLocation () $$ 
DROP PROCEDURE IF EXISTS V20251125190421__Create_SportsTypeAcademyLocation $$ 
DELIMITER ;