DELIMITER $$
DROP PROCEDURE IF EXISTS V20251215183008__Update_SportsClubMembershipRecpnt $$
CREATE PROCEDURE V20251215183008__Update_SportsClubMembershipRecpnt()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT id FROM dtprovider WHERE dataProviderName = 'BUZZ_SPORTS_MEMBERSHIP_REQ_RCPNT')) THEN 
SET @dtproviderid = (SELECT id FROM dtprovider WHERE dataProviderName = 'BUZZ_SPORTS_MEMBERSHIP_REQ_RCPNT');

    -- Update SQL Query
    UPDATE sql_dtprovider 
    SET sqlQuery = "SELECT 
    T1.id AS ID,
    T1.requestId AS REQUEST_ID,
    T1.minimumAmount AS RECEIPT_AMOUNT,
    T3.code AS STUDENT_ID,
    T6.printName AS STUDENT_PRINT_NAME,
    T6.firstName AS STUDENT_FIRST_NAME,
    T6.middleName AS STUDENT_MIDDLE_NAME,
    T6.lastName AS STUDENT_LAST_NAME,
    T6.emailId AS EMAIL_ID,
    T6.mobileNumber AS MOBILE_NO,
    T6.mobileCountryCode AS MOBILE_COUNTRY_CODE,
    T6.printName AS PRINT_NAME,
    T6.firstName AS FIRST_NAME,
    T6.middleName AS MIDDLE_NAME,
    T6.lastName AS LAST_NAME,
    T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    T12.id AS ACADEMY_LOCATION_ID,
    T23.primaryeEmailId AS CAMPUS_EMAIL_ID,
aa.websiteURL AS BRAND_CAMPUS_WEBSITE,
concat(T23.addressText,',',T24.cityName,',',T25.countryName,',',T26.countryRegionName,',',T23.pincode)  AS CAMPUS_ADDRESS,
T24.cityName AS CAMPUS_CITY,
T25.countryName AS CAMPUS_COUNTRY,
T26.countryRegionName AS CAMPUS_COUNTRY_REGION,
T23.pincode AS CAMPUS_POSTAL_CODE,
concat(T23.phoneCountryCode,'',T23.phoneAreaCode,'',T23.phoneNo)  AS CAMPUS_PHONE_NUMBER,
concat(T23.cellCountryCode,'',T23.cellNo)  AS CAMPUS_MOBILE_NUMBER,
T23.primaryeEmailId AS CAMPUS_PRIMARY_EMAIL_ID,
T23.alternateEmailId AS CAMPUS_ALTERNATE_EMAIL_ID,
    
    (CASE
        WHEN
            T12.headerUrl IS NOT NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl, '/', T12.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T12.footerUrl IS NOT NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl, '/', T12.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
	(CASE
        WHEN
            T12.logoUrl IS NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T12.logoUrl IS NULL
                AND T21.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(T21.orgUrl, '/', T12.logoUrl)
    END) AS LOGO_URL
FROM
    service_requests AS T1
        LEFT JOIN
    service_request_settings T7 ON T7.id = T1.serviceRequestSettingId
        LEFT JOIN
    students AS T5 ON T5.userId = T1.requester
       LEFT JOIN
    users T3 ON T3.id = T5.userId
        INNER JOIN
    persons AS T6 ON T6.id = T5.personId
        LEFT OUTER JOIN
    academy_location T12 ON T12.id = T7.academyLocationId
            LEFT JOIN 
    academy_location_addresses ala ON ala.academyLocationId=T12.id
    LEFT JOIN 
    address aa ON aa.id=ala.addressId and aa.addressTypeId=10
	LEFT JOIN
    academies T18 ON T18.id = T12.academyId
	 LEFT JOIN
    organizations T21 ON T21.id = T18.organizationId
        LEFT JOIN
    locations T19 ON T19.id = T12.locationId
           LEFT JOIN
	location_addresses la on la.locationId=T19.id
    LEFT JOIN 
    address T23 ON T23.id = la.addressId
        LEFT JOIN
    city T24 ON T24.id = T23.cityId
        LEFT JOIN
    country T25 ON T25.id = T24.countryId
        LEFT JOIN
    country_region T26 ON T26.id = T24.countryRegionId
                    
WHERE
    T1.id IN (namedParams)"
    WHERE dataProviderId = @dtproviderid; 
    
    UPDATE sql_dtprovider
    SET jsonString = '{
	"id": 1,
	"searchResultViewColumns": [{
			"id": 1,
			"value": "printName",
			"resultKey": "PRINT_NAME",
			"displayCode": "",
			"displayOrder": 0
		},
		{
			"id": 2,
			"value": "firstName",
			"resultKey": "FIRST_NAME",
			"displayCode": "",
			"displayOrder": 1
		},
		{
			"id": 3,
			"value": "middleName",
			"resultKey": "MIDDLE_NAME",
			"displayCode": "",
			"displayOrder": 2
		},
		{
			"id": 4,
			"value": "lastName",
			"resultKey": "LAST_NAME",
			"displayCode": "",
			"displayOrder": 3
		},
		{
			"id": 5,
			"value": "printName",
			"resultKey": "STUDENT_PRINT_NAME",
			"displayCode": "",
			"displayOrder": 4
		},
		{
			"id": 6,
			"value": "firstName",
			"resultKey": "STUDENT_FIRST_NAME",
			"displayCode": "",
			"displayOrder": 5
		},
		{
			"id": 7,
			"value": "lastName",
			"resultKey": "STUDENT_LAST_NAME",
			"displayCode": "",
			"displayOrder": 6
		},
		{
			"id": 8,
			"value": "displayName",
			"resultKey": "ACADEMY_NAME_LOCATION",
			"displayCode": "",
			"displayOrder": 7
		},
		{
			"id": 9,
			"value": "academyName",
			"resultKey": "ACADEMY_NAME",
			"displayCode": "",
			"displayOrder": 8
		},
		{
			"id": 10,
			"value": "locationName",
			"resultKey": "LOCATION_NAME",
			"displayCode": "",
			"displayOrder": 9
		},
		{
			"id": 11,
			"value": "id",
			"resultKey": "ACADEMY_LOCATION_ID",
			"displayCode": "",
			"displayOrder": 10
		},
		{
			"id": 12,
			"value": "headerUrl",
			"resultKey": "HEADER_URL",
			"displayCode": "",
			"displayOrder": 11
		},
		{
			"id": 13,
			"value": "footerUrl",
			"resultKey": "FOOTER_URL",
			"displayCode": "",
			"displayOrder": 12
		},
		{
			"id": 14,
			"value": "logoUrl",
			"resultKey": "LOGO_URL",
			"displayCode": "",
			"displayOrder": 13
		},

		{
			"id": 15,
			"value": "primaryeEmailId",
			"resultKey": "CAMPUS_EMAIL_ID",
			"displayCode": "",
			"displayOrder": 14
		},
		{
			"id": 16,
			"value": "websiteURL",
			"resultKey": "BRAND_CAMPUS_WEBSITE",
			"displayCode": "",
			"displayOrder": 15
		},
		{
			"id": 17,
			"value": "CAMPUS_ADDRESS",
			"resultKey": "CAMPUS_ADDRESS",
			"displayCode": "",
			"displayOrder": 16
		},
		{
			"id": 18,
			"value": "cityName",
			"resultKey": "CAMPUS_CITY",
			"displayCode": "",
			"displayOrder": 17
		},
		{
			"id": 19,
			"value": "countryName",
			"resultKey": "CAMPUS_COUNTRY",
			"displayCode": "",
			"displayOrder": 18
		},
		{
			"id": 20,
			"value": "countryRegionName",
			"resultKey": "CAMPUS_COUNTRY_REGION",
			"displayCode": "",
			"displayOrder": 19
		},
		{
			"id": 21,
			"value": "pincode",
			"resultKey": "CAMPUS_POSTAL_CODE",
			"displayCode": "",
			"displayOrder": 20
		},
		{
			"id": 22,
			"value": "phoneNo",
			"resultKey": "CAMPUS_PHONE_NUMBER",
			"displayCode": "",
			"displayOrder": 21
		},
		{
			"id": 23,
			"value": "cellNo",
			"resultKey": "CAMPUS_MOBILE_NUMBER",
			"displayCode": "",
			"displayOrder": 22
		},
		{
			"id": 24,
			"value": "primaryeEmailId",
			"resultKey": "CAMPUS_PRIMARY_EMAIL_ID",
			"displayCode": "",
			"displayOrder": 23
		},
		{
			"id": 25,
			"value": "alternateEmailId",
			"resultKey": "CAMPUS_ALTERNATE_EMAIL_ID",
			"displayCode": "",
			"displayOrder": 24
		},
		{
			"id": 26,
			"value": "mobileCountryCode",
			"resultKey": "MOBILE_COUNTRY_CODE",
			"displayCode": "",
			"displayOrder": 25
		},
		{
			"id": 27,
			"value": "minimumAmount",
			"resultKey": "RECEIPT_AMOUNT",
			"displayCode": "",
			"displayOrder": 26
		},
		{
			"id": 28,
			"value": "code",
			"resultKey": "STUDENT_ID",
			"displayCode": "",
			"displayOrder": 27
		}
	]
}'
    WHERE dataProviderId = @dtproviderid;
END IF; 
SET SQL_SAFE_UPDATES=1;

INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('BUZZ_SPORTS_MEMBERSHIP_REQ', 'Buzz Sports Club Membership Request');                                                 
      
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('BUZZ_SPORTS_MEMBERSHIP_REQ_DL', 'Buzz Sports Club Membership Request DL');                                                   
      
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('BUZZ_SPORTS_MEMBERSHIP_REQ_RCPNT', 'Buzz Sports Club Membership Request Recipient');                                                    

END $$
CALL V20251215183008__Update_SportsClubMembershipRecpnt () $$
DROP PROCEDURE IF EXISTS V20251215183008__Update_SportsClubMembershipRecpnt $$
DELIMITER ;