DELIMITER $$
DROP PROCEDURE IF EXISTS fatchCreditNoteTobePushedInXero $$
CREATE PROCEDURE fatchCreditNoteTobePushedInXero(jobLastRunTimestamp timestamp)
BEGIN

SELECT 
    FUNC_INC_VAR_SESSION_REC() AS id,
    xUser.xeroContactId AS xeroContactId,
    null as academiaSponsorId,
	xUser.academiaUserId as academiaUserId,
    bill.totalAmount AS unitAmount,
    bill.billNo AS invoiceNumber,
	bill.id AS billHeaderId,
    curr.currencyCode AS currencyCode,
    bill.billingDate AS billingDate,
    bill.dueDate AS dueDate,
    bill.reasonForManualBill AS reason,
    bill.billStatus AS billStatus,
    bill.academyLocationId AS academyLocationId,
    bill.cancellationDate AS cancellationDate,
    bill.cancellationNarration AS cancellationNarration,
    bill.raiseBillCategory AS raiseBillCategory,
    xeroCredMap.id as xeroCredDbId,
    prog.programNameLanguageThree as accountCode,
    xeroCredMap.createdDate as createdDate,
		CONCAT(
        IFNULL(bill.billNo, ''),
        '_',
        IFNULL(bill.reasonForManualBill, '')
		) as description,
	'' as reference
FROM
    xero_user_mapping AS xUser
        JOIN
    bill_header AS bill ON (bill.studentId = xUser.academiaUserId
        AND bill.raiseBillCategory <> 'BILL_RECEIVABLE')
        JOIN
	prog_batch_seat_config As pbsc on pbsc.id=bill.programBatchSeatConfigId
		join 
	batches as batch on batch.id=pbsc.programBatchId
       join 
	programs as prog on prog.id= batch.programId
        LEFT JOIN
    currency AS curr ON bill.currencyId = curr.id
        LEFT JOIN
    xero_credit_note_mapping AS xeroCredMap ON (xeroCredMap.academiaBillHeaderId = bill.id and bill.academyLocationId =xeroCredMap.academyLocationId)
      LEFT JOIN
    drop_down AS drp ON (drp.type = 'XeroRetriggerMaxAttemptDays')
WHERE
    bill.totalAmount IS NOT NULL AND (xeroCredMap.id IS NULL OR (xeroCredMap.error IS NOT NULL
        AND (xeroCredMap.createdDate + INTERVAL CAST(drp.value AS SIGNED) DAY)>=CURRENT_DATE));


END $$

DELIMITER ;