CREATE TABLE `batches_cf_data` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `batchId` bigint(20) DEFAULT NULL,
  `entityFieldMetaDataId` bigint(20) DEFAULT NULL,
  `data` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Refbatch123` (`batchId`),
  KEY `Refentity123` (`entityFieldMetaDataId`),
  CONSTRAINT `Refbatch123` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `Refentity123` FOREIGN KEY (`entityFieldMetaDataId`) REFERENCES `entity_field_meta_data` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE `distribution_list_cf_data` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `distributionId` bigint(20) DEFAULT NULL,
  `entityFieldMetaDataId` bigint(20) DEFAULT NULL,
  `data` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Refdistribution` (`distributionId`),
  KEY `Refentity35` (`entityFieldMetaDataId`),
  CONSTRAINT `Refdistribution` FOREIGN KEY (`distributionId`) REFERENCES `distribution_list` (`id`),
  CONSTRAINT `Refentity35` FOREIGN KEY (`entityFieldMetaDataId`) REFERENCES `entity_field_meta_data` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE `course_reading_cf_data` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `courseReadingId` bigint(20) DEFAULT NULL,
  `entityFieldMetaDataId` bigint(20) DEFAULT NULL,
  `data` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `RefcourseReading15` (`courseReadingId`),
  KEY `RefMetadata142` (`entityFieldMetaDataId`),
  CONSTRAINT `RefcourseReading15` FOREIGN KEY (`courseReadingId`) REFERENCES `course_reading` (`id`),
  CONSTRAINT `RefMetadata142` FOREIGN KEY (`entityFieldMetaDataId`) REFERENCES `entity_field_meta_data` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `program_batch_seat_type_cf_data` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `progBatchSeatConfigId` bigint(20) DEFAULT NULL,
  `entityFieldMetaDataId` bigint(20) DEFAULT NULL,
  `data` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `RefProgBatchSeatConfig` (`progBatchSeatConfigId`),
  KEY `Refentity112` (`entityFieldMetaDataId`),
  CONSTRAINT `Refentity112` FOREIGN KEY (`entityFieldMetaDataId`) REFERENCES `entity_field_meta_data` (`id`),
  CONSTRAINT `RefProgBatchSeatConfig` FOREIGN KEY (`progBatchSeatConfigId`) REFERENCES `prog_batch_seat_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `program_batch_period_cf_data` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `progBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  `entityFieldMetaDataId` bigint(20) DEFAULT NULL,
  `data` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `RefProgBatchPeriodConfig` (`progBatchPeriodConfigId`),
  KEY `Refentity22` (`entityFieldMetaDataId`),
  CONSTRAINT `Refentity22` FOREIGN KEY (`entityFieldMetaDataId`) REFERENCES `entity_field_meta_data` (`id`),
  CONSTRAINT `RefProgBatchPeriodConfig` FOREIGN KEY (`progBatchPeriodConfigId`) REFERENCES `prog_batch_period_config` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `entity_type`
(
`entityName`,
`displayCode`,
`whetherConfigured`,
`entityCode`
)
VALUES
(
'Course Reading Custom Field',
'course_reading_cf_data',
1,'');

INSERT INTO `entity_type`
(
`entityName`,
`displayCode`,
`whetherConfigured`,
`entityCode`
)
VALUES
(
'Study Distribution Custom Field',
'distribution_list_cf_data',
1,'');

INSERT INTO `entity_type`
(
`entityName`,
`displayCode`,
`whetherConfigured`,
`entityCode`
)
VALUES
(
'Batch Custom Field',
'batches_cf_data',
1,'');

INSERT INTO `entity_type`
(
`entityName`,
`displayCode`,
`whetherConfigured`,
`entityCode`
)
VALUES
(
'Seat Type Custom Field',
'program_batch_seat_type_cf_data',
1,'');

INSERT INTO `entity_type`
(
`entityName`,
`displayCode`,
`whetherConfigured`,
`entityCode`
)
VALUES
(
'Program Batch Period Custom Field',
'program_batch_period_cf_data',
1,'');
