

CREATE TABLE `fee_ledger_master` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ledgerName` varchar(255) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Refuser45_idx` (`lastUpdatedBy`),
  KEY `Refacademylocation4565_idx` (`academyLocationId`),
  CONSTRAINT `Ref3455` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refacademylocation4565` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE `receipt_payment_instrument` 
DROP COLUMN `amountPaid`,
DROP COLUMN `depositedIn`,
DROP COLUMN `drawnOn`,
CHANGE COLUMN `paymentMode` `paymentMode` BIGINT(20) NULL DEFAULT NULL ,
CHANGE COLUMN `instrumentAmount` `amount` DOUBLE NULL ,
CHANGE COLUMN `instrumentNo` `instrumentNo` INT(11) NULL ,
CHANGE COLUMN `instrumentDate` `instrumentDate` DATE NULL ,
ADD COLUMN `instrumentBank` BIGINT(20) NULL AFTER `instrumentDate`,
ADD INDEX `Refpaymentmode343_idx` (`paymentMode` ASC);
ALTER TABLE `receipt_payment_instrument` 
ADD CONSTRAINT `Refpaymentmode343`
  FOREIGN KEY (`paymentMode`)
  REFERENCES `fee_payment_modes` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


ALTER TABLE `receipt_payment_instrument` 
ADD INDEX `Refbank3545_idx` (`instrumentBank` ASC);
ALTER TABLE `receipt_payment_instrument` 
ADD CONSTRAINT `Refbank3545`
  FOREIGN KEY (`instrumentBank`)
  REFERENCES `bank` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


ALTER TABLE `receipt_header` 
DROP FOREIGN KEY `Refbill_header613`;
ALTER TABLE `receipt_header` 
DROP COLUMN `billId`,
ADD COLUMN `amount` DOUBLE NULL AFTER `transactionType`,
ADD COLUMN `narration` TEXT NULL AFTER `amount`,
DROP INDEX `Refbill_header613` ;

ALTER TABLE`receipt_payment_instrument` 
CHANGE COLUMN `instrumentNo` `instrumentNo` VARCHAR(255) NULL DEFAULT NULL ;

ALTER TABLE`receipt_header` 
CHANGE COLUMN `voucherType` `voucherType` VARCHAR(102) NULL DEFAULT NULL ,
ADD COLUMN `status` VARCHAR(80) NULL AFTER `narration`;


ALTER TABLE`receipt_header` 
ADD COLUMN `voucherUniqueNumber` INT(11) NULL AFTER `status`;




ALTER TABLE `receipt_header` 
DROP COLUMN `voucherUniqueNumber`,
ADD COLUMN `sponsorId` BIGINT(20) NULL DEFAULT NULL AFTER `voucherType`,
ADD COLUMN `applicantId` BIGINT(20) NULL DEFAULT NULL AFTER `sponsorId`,
ADD COLUMN `thirdPartyId` BIGINT(20) NULL DEFAULT NULL AFTER `applicantId`,
ADD COLUMN `userId` BIGINT(20) NULL DEFAULT NULL AFTER `thirdPartyId`,
ADD COLUMN `studentId` BIGINT(20) NULL DEFAULT NULL AFTER `userId`,
ADD COLUMN `receiptNo` VARCHAR(200) NOT NULL AFTER `studentId`,
ADD COLUMN `receiptUniqueNumber` INT(20) NULL DEFAULT NULL AFTER `receiptNo`,
ADD COLUMN `iauId` BIGINT(20) NULL DEFAULT NULL AFTER `receiptUniqueNumber`,
ADD COLUMN `currencyId` BIGINT(20) NULL DEFAULT NULL AFTER `iauId`,
ADD COLUMN `approver` BIGINT(20) NULL DEFAULT NULL AFTER `currencyId`,
ADD COLUMN `approvalDate` DATE NULL DEFAULT NULL AFTER `approver`;

ALTER TABLE `receipt_header` 
ADD INDEX `Refapplicant343_idx` (`applicantId` ASC);
ALTER TABLE `receipt_header` 
ADD CONSTRAINT `Refapplicant343`
  FOREIGN KEY (`applicantId`)
  REFERENCES `application` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `receipt_header` 
ADD INDEX `Refstudent7645_idx` (`studentId` ASC);
ALTER TABLE `receipt_header` 
ADD CONSTRAINT `Refstudent7645`
  FOREIGN KEY (`studentId`)
  REFERENCES `students` (`personId`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `receipt_header` 
ADD INDEX `Reffeethirdparty543_idx` (`thirdPartyId` ASC),
ADD INDEX `Refsponsor332_idx` (`sponsorId` ASC);
ALTER TABLE `receipt_header` 
ADD CONSTRAINT `Reffeethirdparty543`
  FOREIGN KEY (`thirdPartyId`)
  REFERENCES `fee_third_parties` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `Refsponsor332`
  FOREIGN KEY (`sponsorId`)
  REFERENCES `sponsors` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `receipt_header` 
ADD INDEX `Refuser87_idx` (`userId` ASC);
ALTER TABLE `receipt_header` 
ADD CONSTRAINT `Refuser87`
  FOREIGN KEY (`userId`)
  REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `receipt_header` 
ADD INDEX `Refcurrency34_idx` (`currencyId` ASC);
ALTER TABLE `receipt_header` 
ADD CONSTRAINT `Refcurrency34`
  FOREIGN KEY (`currencyId`)
  REFERENCES `currency` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `receipt_header` 
ADD INDEX `Reforganizationunits_idx` (`iauId` ASC);
ALTER TABLE `receipt_header` 
ADD CONSTRAINT `Reforganizationunits56`
  FOREIGN KEY (`iauId`)
  REFERENCES `organization_units` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


ALTER TABLE `receipt_header` 
DROP COLUMN `approvalDate`,
DROP COLUMN `approver`;

ALTER TABLE `receipt_header` 
DROP COLUMN `toBeDeleted`;

ALTER TABLE `receipt_header` 
ADD COLUMN `depositedBank` BIGINT(11) NULL AFTER `status`,
ADD COLUMN `depositedCash` BIGINT(11) NULL AFTER `depositedBank`;


ALTER TABLE `receipt_header` 
ADD INDEX `RefBank3435_idx` (`depositedBank` ASC),
ADD INDEX `Reffee_ladger_master_idx` (`depositedCash` ASC);
ALTER TABLE `receipt_header` 
ADD CONSTRAINT `RefBank3435`
  FOREIGN KEY (`depositedBank`)
  REFERENCES `bank` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `Reffee_ladger_master5434`
  FOREIGN KEY (`depositedCash`)
  REFERENCES `fee_ledger_master` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


ALTER TABLE `receipt_payment_instrument` 
DROP FOREIGN KEY `Refbank3545`;


CREATE TABLE `bank_drawn_on_master` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `bankName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refuser345_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refuser345` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



ALTER TABLE `receipt_payment_instrument` 
ADD CONSTRAINT `Refbankdrawnon_master`
  FOREIGN KEY (`instrumentBank`)
  REFERENCES `bank_drawn_on_master` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;