
CREATE TABLE `evaluation_plan_rank` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `evaluationPlanId` BIGINT(20) NULL,
  `admissionId` BIGINT(20) NULL,
  `rank` INT(11) NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_evaluation_plan_rank_1_idx` (`evaluationPlanId` ASC),
  INDEX `fk_admissionId_idx` (`admissionId` ASC),
  CONSTRAINT `fk_evaluationPlanId`
    FOREIGN KEY (`evaluationPlanId`)
    REFERENCES `evaluation_plan` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_admissionId`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

ALTER TABLE `evaluation_plan_rank` 
ADD INDEX `fk_usersId_idx` (`lastUpdatedBy` ASC);
ALTER TABLE `evaluation_plan_rank` 
ADD CONSTRAINT `fk_usersId`
  FOREIGN KEY (`lastUpdatedBy`)
  REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


CREATE TABLE `evaluation_plan_level_one_rank` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `evaluationPlanLevelOneId` BIGINT(20) NULL,
  `admissionId` BIGINT(20) NULL,
  `rank` INT(11) NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_evaluationPlanLevelOneId_1_idx` (`evaluationPlanLevelOneId` ASC),
  INDEX `fk_admissionId_1_idx` (`admissionId` ASC),
  INDEX `fk_users_1_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_evaluationPlanLevelOneId_1`
    FOREIGN KEY (`evaluationPlanLevelOneId`)
    REFERENCES `evaluation_plan_level_one` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_admissionId_1`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_users_1`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);



CREATE TABLE `evaluation_plan_level_two_rank` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `evaluationPlanLevelTwoId` BIGINT(20) NULL,
  `admissionId` BIGINT(20) NULL,
  `rank` INT(11) NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_evaluationPlanLevelTwoId_2_idx` (`evaluationPlanLevelTwoId` ASC),
  INDEX `fk_admissionId_2_idx` (`admissionId` ASC),
  INDEX `fk_users_2_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_evaluationPlanLevelTwoId_2`
    FOREIGN KEY (`evaluationPlanLevelTwoId`)
    REFERENCES `evaluation_plan_level_two` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_admissionId_2`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_users_2`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);



CREATE TABLE `evaluation_sequence_rank` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `evaluationSequenceId` BIGINT(20) NULL,
  `admissionId` BIGINT(20) NULL,
  `rank` INT(11) NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_evaluationSequenceId_3_idx` (`evaluationSequenceId` ASC),
  INDEX `fk_admissionId_3_idx` (`admissionId` ASC),
  INDEX `fk_users_3_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_evaluationSequenceId_3`
    FOREIGN KEY (`evaluationSequenceId`)
    REFERENCES `evaluation_sequence` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_admissionId_3`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_users_3`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);



CREATE TABLE `evaluation_program_rank` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `programBatchPeriodId` BIGINT(20) NULL,
  `admissionId` BIGINT(20) NULL,
  `rank` INT(11) NULL,
  `SGPA` DOUBLE(20,2) NULL,
  `CGPA` DOUBLE(20,2) NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_programBatchPeriodId_4_idx` (`programBatchPeriodId` ASC),
  INDEX `fk_admissionId_4_idx` (`admissionId` ASC),
  INDEX `fk_users_4_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_programBatchPeriodId_4`
    FOREIGN KEY (`programBatchPeriodId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_admissionId_4`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_users_4`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);



ALTER TABLE `evaluation_plan_rank` 
ADD COLUMN `gradePoint` DOUBLE(20,2) NULL AFTER `lastUpdate`,
ADD COLUMN `grade` VARCHAR(45) NULL AFTER `gradePoint`,
ADD COLUMN `obtainedMarks` DOUBLE(20,2) NULL AFTER `grade`;


ALTER TABLE `evaluation_plan_level_one_rank` 
ADD COLUMN `gradePoint` DOUBLE(20,2) NULL AFTER `lastUpdate`,
ADD COLUMN `grade` VARCHAR(45) NULL AFTER `gradePoint`,
ADD COLUMN `obtainedMarks` DOUBLE(20,2) NULL AFTER `grade`;


ALTER TABLE `evaluation_plan_level_two_rank` 
ADD COLUMN `gradePoint` DOUBLE(20,2) NULL AFTER `lastUpdate`,
ADD COLUMN `grade` VARCHAR(45) NULL AFTER `gradePoint`,
ADD COLUMN `obtainedMarks` DOUBLE(20,2) NULL AFTER `grade`;

ALTER TABLE `evaluation_sequence_rank` 
ADD COLUMN `gradePoint` DOUBLE(20,2) NULL AFTER `lastUpdate`,
ADD COLUMN `grade` VARCHAR(45) NULL AFTER `gradePoint`,
ADD COLUMN `obtainedMarks` DOUBLE(20,2) NULL AFTER `grade`;

ALTER TABLE `evaluation_program_rank` 
ADD COLUMN `gradePoint` DOUBLE(20,2) NULL AFTER `lastUpdate`,
ADD COLUMN `grade` VARCHAR(45) NULL AFTER `gradePoint`,
ADD COLUMN `obtainedMarks` DOUBLE(20,2) NULL AFTER `grade`;
